/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.io.typed;

import com.bawnorton.configurable.util.GenericType;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;

public class TypedReader<T> {
    private JsonReader<T> jsonReader;
    private TomlReader<T> tomlReader;
    private ObjectReader<T> objectReader;
    private ByteBufReader<T> byteBufReader;

    public static <T> TypedReader<T> create() {
        return new TypedReader<T>();
    }

    public TypedReader<T> json(JsonReader<T> reader) {
        this.jsonReader = reader;
        return this;
    }

    public TypedReader<T> toml(TomlReader<T> reader) {
        this.tomlReader = reader;
        return this;
    }

    public TypedReader<T> object(ObjectReader<T> reader) {
        this.objectReader = reader;
        return this;
    }

    public TypedReader<T> byteBuf(ByteBufReader<T> reader) {
        this.byteBufReader = reader;
        return this;
    }

    T readJson(JsonElement element, GenericType expectedType) {
        if (this.jsonReader == null) {
            throw new UnsupportedOperationException("JSON reading not supported for this type");
        }
        return this.jsonReader.read(element, expectedType);
    }

    T readToml(CommentedConfig config, String path, GenericType expectedType) {
        if (this.tomlReader == null) {
            throw new UnsupportedOperationException("TOML reading not supported for this type");
        }
        return this.tomlReader.read(config, path, expectedType);
    }

    T readObject(Object item, GenericType expectedType) {
        if (this.objectReader == null) {
            throw new UnsupportedOperationException("Object reading not supported for this type");
        }
        try {
            return this.objectReader.read(item, expectedType);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Failed to read object: " + String.valueOf(item) + " of type " + item.getClass().getName(), e);
        }
    }

    T readByteBuf(ByteBuf buf, GenericType expectedType) {
        if (this.byteBufReader == null) {
            throw new UnsupportedOperationException("ByteBuf reading not supported for this type");
        }
        return this.byteBufReader.read(buf, expectedType);
    }

    public static interface JsonReader<T> {
        public static <T> Contextless<T> contextless(Contextless<T> reader) {
            return reader;
        }

        public T read(JsonElement var1, GenericType var2);

        public static interface Contextless<T>
        extends JsonReader<T> {
            public T read(JsonElement var1);

            @Override
            default public T read(JsonElement element, GenericType expectedType) {
                return this.read(element);
            }
        }
    }

    public static interface TomlReader<T> {
        public static <T> Contextless<T> contextless(Contextless<T> reader) {
            return reader;
        }

        public T read(CommentedConfig var1, String var2, GenericType var3);

        public static interface Contextless<T>
        extends TomlReader<T> {
            public T read(CommentedConfig var1, String var2);

            @Override
            default public T read(CommentedConfig config, String path, GenericType expectedType) {
                return this.read(config, path);
            }
        }
    }

    public static interface ObjectReader<T> {
        public static <T> Contextless<T> contextless(Contextless<T> reader) {
            return reader;
        }

        public T read(Object var1, GenericType var2);

        public static interface Contextless<T>
        extends ObjectReader<T> {
            public T read(Object var1);

            @Override
            default public T read(Object item, GenericType expectedType) {
                return this.read(item);
            }
        }
    }

    public static interface ByteBufReader<T> {
        public static <T> Contextless<T> contextless(Contextless<T> reader) {
            return reader;
        }

        public T read(ByteBuf var1, GenericType var2);

        public static interface Contextless<T>
        extends ByteBufReader<T> {
            public T read(ByteBuf var1);

            @Override
            default public T read(ByteBuf buf, GenericType expectedType) {
                return this.read(buf);
            }
        }
    }
}

