/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.io;

import com.bawnorton.configurable.io.typed.TypedHandler;
import com.bawnorton.configurable.io.typed.TypedHandlerCollection;
import com.bawnorton.configurable.io.typed.TypedReader;
import com.bawnorton.configurable.io.typed.TypedWriter;
import com.bawnorton.configurable.util.GenericType;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class SerialisationHelper {
    private static final TypedHandlerCollection TYPED_HANDLERS = new TypedHandlerCollection();
    private static final TypedHandler<Enum<?>> ENUM_HANDLER;
    private static final TypedHandler<Object> ARRAY_HANDLER;
    private static final TypedHandler<List<?>> LIST_HANDLER;

    public static Object interpret(JsonElement element, GenericType genericType) {
        return SerialisationHelper.getTypedHandler(genericType).readFromJson(element);
    }

    public static Object interpret(CommentedConfig toml, String path, GenericType genericType) {
        return SerialisationHelper.getTypedHandler(genericType).readFromToml(toml, path);
    }

    public static Object interpret(Object item, GenericType genericType) {
        return SerialisationHelper.getTypedHandler(genericType).readFromObject(item);
    }

    public static Object interpet(ByteBuf byteBuf, GenericType genericType) {
        return SerialisationHelper.getTypedHandler(genericType).readFromByteBuf(byteBuf);
    }

    public static void encode(ByteBuf byteBuf, Object value, GenericType genericType) {
        SerialisationHelper.getTypedHandler(genericType).writeToByteBuf(byteBuf, value);
    }

    @NotNull
    private static TypedHandler<?> getTypedHandler(GenericType genericType) {
        TypedHandler<Object> handler = genericType.type().isEnum() ? ENUM_HANDLER : (genericType.type().isArray() ? ARRAY_HANDLER : (List.class.isAssignableFrom(genericType.type()) ? LIST_HANDLER : TYPED_HANDLERS.getHandlerFor(genericType)));
        handler.attachExpectedType(genericType);
        return handler;
    }

    public static Object safeForToml(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type.isEnum()) {
            return value.toString();
        }
        if (type.isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> asList = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                asList.add(SerialisationHelper.safeForToml(item));
            }
            return asList;
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> safeList = new ArrayList<Object>(list.size());
            for (Object item : list) {
                safeList.add(SerialisationHelper.safeForToml(item));
            }
            return safeList;
        }
        if (type == Character.class) {
            return value.toString();
        }
        return value;
    }

    static {
        TYPED_HANDLERS.register(String.class, null, TypedReader.create().json(TypedReader.JsonReader.contextless(JsonElement::getAsString)).toml(TypedReader.TomlReader.contextless(UnmodifiableConfig::get)).object(TypedReader.ObjectReader.contextless(Object::toString)).byteBuf(TypedReader.ByteBufReader.contextless(arg_0 -> ((StreamCodec)ByteBufCodecs.STRING_UTF8).decode(arg_0))), TypedWriter.create().byteBuf(TypedWriter.ByteBufWriter.contextless((arg_0, arg_1) -> ((StreamCodec)ByteBufCodecs.STRING_UTF8).encode(arg_0, arg_1))));
        TYPED_HANDLERS.register(Integer.class, Integer.TYPE, TypedReader.create().json(TypedReader.JsonReader.contextless(JsonElement::getAsInt)).toml(TypedReader.TomlReader.contextless(UnmodifiableConfig::getInt)).object(TypedReader.ObjectReader.contextless(item -> ((Number)item).intValue())).byteBuf(TypedReader.ByteBufReader.contextless(arg_0 -> ((StreamCodec)ByteBufCodecs.VAR_INT).decode(arg_0))), TypedWriter.create().byteBuf(TypedWriter.ByteBufWriter.contextless((arg_0, arg_1) -> ((StreamCodec)ByteBufCodecs.VAR_INT).encode(arg_0, arg_1))));
        TYPED_HANDLERS.register(Long.class, Long.TYPE, TypedReader.create().json(TypedReader.JsonReader.contextless(JsonElement::getAsLong)).toml(TypedReader.TomlReader.contextless((config, path) -> ((Number)config.getRaw(path)).longValue())).object(TypedReader.ObjectReader.contextless(item -> ((Number)item).longValue())).byteBuf(TypedReader.ByteBufReader.contextless(arg_0 -> ((StreamCodec)ByteBufCodecs.VAR_LONG).decode(arg_0))), TypedWriter.create().byteBuf(TypedWriter.ByteBufWriter.contextless((arg_0, arg_1) -> ((StreamCodec)ByteBufCodecs.VAR_LONG).encode(arg_0, arg_1))));
        TYPED_HANDLERS.register(Boolean.class, Boolean.TYPE, TypedReader.create().json(TypedReader.JsonReader.contextless(JsonElement::getAsBoolean)).toml(TypedReader.TomlReader.contextless(UnmodifiableConfig::get)).object(TypedReader.ObjectReader.contextless(item -> (Boolean)item)).byteBuf(TypedReader.ByteBufReader.contextless(arg_0 -> ((StreamCodec)ByteBufCodecs.BOOL).decode(arg_0))), TypedWriter.create().byteBuf(TypedWriter.ByteBufWriter.contextless((arg_0, arg_1) -> ((StreamCodec)ByteBufCodecs.BOOL).encode(arg_0, arg_1))));
        TYPED_HANDLERS.register(Double.class, Double.TYPE, TypedReader.create().json(TypedReader.JsonReader.contextless(JsonElement::getAsDouble)).toml(TypedReader.TomlReader.contextless((config, path) -> ((Number)config.getRaw(path)).doubleValue())).object(TypedReader.ObjectReader.contextless(item -> ((Number)item).doubleValue())).byteBuf(TypedReader.ByteBufReader.contextless(arg_0 -> ((StreamCodec)ByteBufCodecs.DOUBLE).decode(arg_0))), TypedWriter.create().byteBuf(TypedWriter.ByteBufWriter.contextless((arg_0, arg_1) -> ((StreamCodec)ByteBufCodecs.DOUBLE).encode(arg_0, arg_1))));
        TYPED_HANDLERS.register(Float.class, Float.TYPE, TypedReader.create().json(TypedReader.JsonReader.contextless(JsonElement::getAsFloat)).toml(TypedReader.TomlReader.contextless((config, path) -> Float.valueOf(((Number)config.getRaw(path)).floatValue()))).object(TypedReader.ObjectReader.contextless(item -> Float.valueOf(((Number)item).floatValue()))).byteBuf(TypedReader.ByteBufReader.contextless(arg_0 -> ((StreamCodec)ByteBufCodecs.FLOAT).decode(arg_0))), TypedWriter.create().byteBuf(TypedWriter.ByteBufWriter.contextless((arg_0, arg_1) -> ((StreamCodec)ByteBufCodecs.FLOAT).encode(arg_0, arg_1))));
        TYPED_HANDLERS.register(Byte.class, Byte.TYPE, TypedReader.create().json(TypedReader.JsonReader.contextless(element -> element.getAsNumber().byteValue())).toml(TypedReader.TomlReader.contextless(UnmodifiableConfig::getByte)).object(TypedReader.ObjectReader.contextless(item -> ((Number)item).byteValue())).byteBuf(TypedReader.ByteBufReader.contextless(arg_0 -> ((StreamCodec)ByteBufCodecs.BYTE).decode(arg_0))), TypedWriter.create().byteBuf(TypedWriter.ByteBufWriter.contextless((arg_0, arg_1) -> ((StreamCodec)ByteBufCodecs.BYTE).encode(arg_0, arg_1))));
        TYPED_HANDLERS.register(Short.class, Short.TYPE, TypedReader.create().json(TypedReader.JsonReader.contextless(element -> element.getAsNumber().shortValue())).toml(TypedReader.TomlReader.contextless(UnmodifiableConfig::getShort)).object(TypedReader.ObjectReader.contextless(item -> ((Number)item).shortValue())).byteBuf(TypedReader.ByteBufReader.contextless(arg_0 -> ((StreamCodec)ByteBufCodecs.SHORT).decode(arg_0))), TypedWriter.create().byteBuf(TypedWriter.ByteBufWriter.contextless((arg_0, arg_1) -> ((StreamCodec)ByteBufCodecs.SHORT).encode(arg_0, arg_1))));
        Function<String, Character> charParser = str -> {
            if (str.length() != 1) {
                throw new IllegalArgumentException("Expected a single character for type char, but got: %s".formatted(str));
            }
            return Character.valueOf(str.charAt(0));
        };
        TYPED_HANDLERS.register(Character.class, Character.TYPE, TypedReader.create().json(TypedReader.JsonReader.contextless(element -> (Character)charParser.apply(element.getAsString()))).toml(TypedReader.TomlReader.contextless((config, path) -> (Character)charParser.apply((String)config.get(path)))).object(TypedReader.ObjectReader.contextless(item -> (Character)charParser.apply(item.toString()))).byteBuf(TypedReader.ByteBufReader.contextless(byteBuf -> Character.valueOf((char)((Integer)ByteBufCodecs.VAR_INT.decode((Object)byteBuf)).intValue()))), TypedWriter.create().byteBuf(TypedWriter.ByteBufWriter.contextless((byteBuf, value) -> ByteBufCodecs.VAR_INT.encode((Object)byteBuf, (Object)value.charValue()))));
        ENUM_HANDLER = new TypedHandler<Enum>(TypedReader.create().json((element, expectedType) -> Enum.valueOf(expectedType.type(), element.getAsString())).toml((config, path, expectedType) -> Enum.valueOf(expectedType.type(), (String)config.get(path))).object((item, expectedType) -> Enum.valueOf(expectedType.type(), item.toString())).byteBuf((byteBuf, expectedType) -> Enum.valueOf(expectedType.type(), (String)ByteBufCodecs.STRING_UTF8.decode((Object)byteBuf))), TypedWriter.create().byteBuf((byteBuf, item, expectedType) -> ByteBufCodecs.STRING_UTF8.encode((Object)byteBuf, (Object)item.name())));
        ARRAY_HANDLER = new TypedHandler<Object>(TypedReader.create().json((element, expectedType) -> {
            if (!element.isJsonArray()) {
                throw new IllegalArgumentException("Expected a JSON array for type array, but got: %s".formatted(element));
            }
            JsonArray jsonArray = element.getAsJsonArray();
            int size = jsonArray.size();
            Class<?> componentType = expectedType.type().getComponentType();
            Object array = Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                JsonElement jsonElement = jsonArray.get(i);
                Object value = SerialisationHelper.interpret(jsonElement, new GenericType(componentType, new GenericType[0]));
                Array.set(array, i, value);
            }
            return array;
        }).toml((config, path, expectedType) -> {
            List list = (List)config.get(path);
            if (list == null) {
                return null;
            }
            Class<?> componentType = expectedType.type().getComponentType();
            int size = list.size();
            Object array = Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                Object item = list.get(i);
                Object value = SerialisationHelper.interpret(item, new GenericType(componentType, new GenericType[0]));
                Array.set(array, i, value);
            }
            return array;
        }).object((item, expectedType) -> {
            if (!(item instanceof List)) {
                throw new IllegalArgumentException("Expected a List for type array, but got: %s".formatted(item));
            }
            List list = (List)item;
            Class<?> componentType = expectedType.type().getComponentType();
            int size = list.size();
            Object array = Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                Object value = SerialisationHelper.interpret(list.get(i), new GenericType(componentType, new GenericType[0]));
                Array.set(array, i, value);
            }
            return array;
        }).byteBuf((byteBuf, expectedType) -> {
            int length = (Integer)ByteBufCodecs.VAR_INT.decode((Object)byteBuf);
            Class<?> componentType = expectedType.type().getComponentType();
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Object item = SerialisationHelper.interpet(byteBuf, new GenericType(componentType, new GenericType[0]));
                Array.set(array, i, item);
            }
            return array;
        }), TypedWriter.create().byteBuf((byteBuf, item, expectedType) -> {
            int length = Array.getLength(item);
            ByteBufCodecs.VAR_INT.encode((Object)byteBuf, (Object)length);
            Class<?> componentType = expectedType.type().getComponentType();
            for (int i = 0; i < length; ++i) {
                Object arrayItem = Array.get(item, i);
                SerialisationHelper.encode(byteBuf, arrayItem, new GenericType(componentType, new GenericType[0]));
            }
        }));
        LIST_HANDLER = new TypedHandler<List>(TypedReader.create().json((element, expectedType) -> {
            if (!element.isJsonArray()) {
                throw new IllegalArgumentException("Expected a JSON array for type List, but got: %s".formatted(element));
            }
            ArrayList<Object> interpretedList = new ArrayList<Object>();
            for (JsonElement item : element.getAsJsonArray()) {
                interpretedList.add(SerialisationHelper.interpret(item, expectedType.genericTypes()[0]));
            }
            return interpretedList;
        }).toml((config, path, expectedType) -> {
            List list = (List)config.get(path);
            if (list == null) {
                return null;
            }
            ArrayList<Object> interpretedList = new ArrayList<Object>(list.size());
            for (Object item : list) {
                interpretedList.add(SerialisationHelper.interpret(item, expectedType.genericTypes()[0]));
            }
            return interpretedList;
        }).object((item, expectedType) -> {
            if (!(item instanceof List)) {
                throw new IllegalArgumentException("Expected a List for type List, but got: %s".formatted(item));
            }
            List list = (List)item;
            ArrayList<Object> interpretedList = new ArrayList<Object>(list.size());
            for (Object listItem : list) {
                interpretedList.add(SerialisationHelper.interpret(listItem, expectedType.genericTypes()[0]));
            }
            return interpretedList;
        }).byteBuf((byteBuf, expectedType) -> {
            int length = (Integer)ByteBufCodecs.VAR_INT.decode((Object)byteBuf);
            ArrayList<Object> interpretedList = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                Object item = SerialisationHelper.interpet(byteBuf, expectedType.genericTypes()[0]);
                interpretedList.add(item);
            }
            return interpretedList;
        }), TypedWriter.create().byteBuf((byteBuf, item, expectedType) -> {
            ByteBufCodecs.VAR_INT.encode((Object)byteBuf, (Object)item.size());
            for (Object listItem : item) {
                SerialisationHelper.encode(byteBuf, listItem, expectedType.genericTypes()[0]);
            }
        }));
    }
}

