/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.setup;

import com.davenonymous.patternconverter.api.plugin.IPatternConverter;
import com.davenonymous.patternconverter.datacomponents.ConverterStyleDataComponent;
import com.davenonymous.patternconverter.mods.ConverterStyle;
import com.davenonymous.patternconverter.mods.PluginLoader;
import com.davenonymous.patternconverter.setup.ModDataComponents;
import com.davenonymous.patternconverter.setup.ModItems;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@EventBusSubscriber
public class CreativeTabHooks {
    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        ItemStack converterItem = new ItemStack((ItemLike)ModItems.CONVERTER_ITEM.get());
        for (Map.Entry<String, IPatternConverter> converterEntry : PluginLoader.converterMap.entrySet()) {
            String modId = converterEntry.getKey();
            IPatternConverter converter = converterEntry.getValue();
            if (converter.creativeTab().isEmpty() || event.getTabKey() != converter.creativeTab().get()) continue;
            ItemStack recipeOutputStack = converterItem.copy();
            recipeOutputStack.set((DataComponentType)ModDataComponents.CONVERTER_STYLE_COMPONENT.get(), (Object)new ConverterStyleDataComponent(ConverterStyle.byMod(modId)));
            event.accept(recipeOutputStack);
        }
    }
}

