/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.mods;

import com.davenonymous.patternconverter.PatternConverter;
import com.davenonymous.patternconverter.api.IUniversalPattern;
import com.davenonymous.patternconverter.api.impl.UniversalCraftingPattern;
import com.davenonymous.patternconverter.api.impl.UniversalProcessingPattern;
import com.davenonymous.patternconverter.api.impl.UniversalSmithingPattern;
import com.davenonymous.patternconverter.api.impl.UniversalStonecutterPattern;
import com.davenonymous.patternconverter.api.plugin.IPatternConverter;
import com.davenonymous.patternconverter.api.plugin.PatternConverterSupport;
import com.davenonymous.patternconverter.api.types.IUniversalCraftingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalProcessingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalSmithingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalStonecutterPattern;
import com.davenonymous.patternconverter.api.wrapper.FluidTagIngredient;
import com.davenonymous.patternconverter.api.wrapper.ItemTagIngredient;
import com.davenonymous.patternconverter.api.wrapper.UniversalFluidIngredient;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderItem;
import com.refinedmods.refinedstorage.common.autocrafting.CraftingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.SmithingTablePatternState;
import com.refinedmods.refinedstorage.common.autocrafting.StonecutterPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridBlockEntity;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

@PatternConverterSupport(modid="refinedstorage")
public class RefinedStorage
implements IPatternConverter {
    @Override
    public Item patternItem() {
        return Items.INSTANCE.getPattern();
    }

    @Override
    public Optional<ResourceKey<CreativeModeTab>> creativeTab() {
        ResourceLocation rfTabId = RefinedStorageApi.INSTANCE.getCreativeModeTabId();
        CreativeModeTab tab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(rfTabId);
        if (tab == null) {
            PatternConverter.LOGGER.warn("Refined Storage creative mode tab not found: " + String.valueOf(rfTabId));
            return Optional.empty();
        }
        return BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey((Object)tab);
    }

    @Override
    public boolean isEmptyPattern(ItemStack stack, Level level) {
        Item item = stack.getItem();
        if (!(item instanceof PatternProviderItem)) {
            return false;
        }
        PatternProviderItem patternItem = (PatternProviderItem)item;
        Optional pattern = patternItem.getPattern(stack, level);
        Optional output = patternItem.getOutput(stack, level);
        return pattern.isEmpty() && output.isEmpty();
    }

    public UniversalCraftingPattern readCraftingPattern(ItemStack stack, List<Ingredient> inputs, Level level) {
        CraftingPatternState craftingState = (CraftingPatternState)stack.get(DataComponents.INSTANCE.getCraftingPatternState());
        if (craftingState == null) {
            return null;
        }
        CraftingInput craftingInput = craftingState.input().input();
        UniversalCraftingPattern result = new UniversalCraftingPattern(craftingInput);
        result.setAllItemsFuzzy(craftingState.fuzzyMode());
        result.setPatternHeight(craftingInput.height());
        result.setPatternWidth(craftingInput.width());
        return result;
    }

    public UniversalSmithingPattern readSmithingPattern(ItemStack stack, List<Ingredient> inputs, Level level) {
        SmithingTablePatternState smithingState = (SmithingTablePatternState)stack.get(DataComponents.INSTANCE.getSmithingTablePatternState());
        if (smithingState == null) {
            return null;
        }
        UniversalSmithingPattern result = new UniversalSmithingPattern(smithingState.template().toItemStack(), smithingState.base().toItemStack(), smithingState.addition().toItemStack());
        return result;
    }

    public UniversalStonecutterPattern readStonecutterPattern(ItemStack stack, List<Ingredient> inputs, Level level) {
        StonecutterPatternState stonecutterState = (StonecutterPatternState)stack.get(DataComponents.INSTANCE.getStonecutterPatternState());
        if (stonecutterState == null) {
            return null;
        }
        UniversalStonecutterPattern result = new UniversalStonecutterPattern(stonecutterState.input().toItemStack());
        return result;
    }

    public UniversalProcessingPattern readProcessingPattern(ItemStack stack, List<Ingredient> inputs, Level level) {
        ProcessingPatternState processingState = (ProcessingPatternState)stack.get(DataComponents.INSTANCE.getProcessingPatternState());
        if (processingState == null) {
            return null;
        }
        UniversalProcessingPattern result = new UniversalProcessingPattern();
        for (ProcessingPatternState.ProcessingIngredient processingIngredient : processingState.ingredients().stream().filter(Optional::isPresent).map(Optional::get).toList()) {
            Object tagIngredient;
            com.refinedmods.refinedstorage.api.resource.ResourceKey resourceKey = processingIngredient.input().resource();
            long amount = processingIngredient.input().amount();
            if (resourceKey instanceof ItemResource) {
                ItemResource itemResource = (ItemResource)resourceKey;
                ItemStack itemStack = itemResource.toItemStack(amount);
                if (processingIngredient.allowedAlternativeIds().isEmpty()) {
                    result.addInput(itemStack);
                    continue;
                }
                tagIngredient = new ItemTagIngredient(itemStack, processingIngredient.allowedAlternativeIds().stream().map(ResourceLocation::toString).toList());
                ((ItemTagIngredient)tagIngredient).setAmount(amount);
                result.addInput((ItemTagIngredient)tagIngredient);
                continue;
            }
            if (!(resourceKey instanceof FluidResource)) continue;
            FluidResource fluidResource = (FluidResource)resourceKey;
            FluidStack fluidStack = new FluidStack(fluidResource.fluid(), (int)amount);
            if (processingIngredient.allowedAlternativeIds().isEmpty()) {
                result.addInput(fluidStack);
                continue;
            }
            tagIngredient = new FluidTagIngredient(fluidStack, processingIngredient.allowedAlternativeIds().stream().map(ResourceLocation::toString).toList());
            ((FluidTagIngredient)tagIngredient).setAmount(amount);
            result.addInput((FluidTagIngredient)tagIngredient);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IUniversalPattern readPattern(ItemStack stack, Level level) {
        var4_3 = stack.getItem();
        if (!(var4_3 instanceof PatternProviderItem)) {
            return null;
        }
        patternItem = (PatternProviderItem)var4_3;
        optPattern = patternItem.getPattern(stack, level);
        optOutput = patternItem.getOutput(stack, level);
        if (optPattern.isEmpty() || optOutput.isEmpty()) {
            return null;
        }
        pattern = (Pattern)optPattern.get();
        inputs = pattern.layout().ingredients();
        outputs = pattern.layout().outputs();
        result = this.readCraftingPattern(stack, inputs, level);
        if (result == null) {
            result = this.readSmithingPattern(stack, inputs, level);
        }
        if (result == null) {
            result = this.readStonecutterPattern(stack, inputs, level);
        }
        if (result == null) {
            result = this.readProcessingPattern(stack, inputs, level);
        }
        if (result == null) {
            PatternConverter.LOGGER.warn("Could not read pattern from stack: " + String.valueOf(stack));
            return null;
        }
        outputIndex = 0;
        for (ResourceAmount output : outputs) {
            block15: {
                block14: {
                    resourceKey = output.resource();
                    amount = output.amount();
                    if (!(resourceKey instanceof ItemResource)) break block14;
                    itemResource = (ItemResource)resourceKey;
                    itemStack = itemResource.toItemStack(amount);
                    result.addOutput(itemStack);
                    break block15;
                }
                if (!(result instanceof IUniversalProcessingPattern)) ** GOTO lbl-1000
                processingResult = (IUniversalProcessingPattern)result;
                if (resourceKey instanceof FluidResource) {
                    fluidResource = (FluidResource)resourceKey;
                    fluidStack = new FluidStack(fluidResource.fluid(), (int)amount);
                    processingResult.addOutput(fluidStack);
                } else lbl-1000:
                // 2 sources

                {
                    PatternConverter.LOGGER.warn("Unknown resource type for output {}: {}", (Object)outputIndex, (Object)resourceKey);
                }
            }
            ++outputIndex;
        }
        if (result instanceof UniversalCraftingPattern) {
            craftingPattern = result;
            craftingPattern.guessRecipe(level);
        } else if (result instanceof UniversalStonecutterPattern) {
            stonecutterPattern = (UniversalStonecutterPattern)result;
            stonecutterPattern.guessRecipe(level);
        } else if (result instanceof UniversalSmithingPattern) {
            smithingPattern = (UniversalSmithingPattern)result;
            smithingPattern.guessRecipe(level);
        }
        return result;
    }

    @Override
    public ItemStack writePattern(IUniversalProcessingPattern pattern, Level level) {
        Object tagIngredient;
        ResourceAmount resourceAmount;
        ItemStack stack;
        ItemStack unencodedPattern = PatternGridBlockEntity.createPatternStack((PatternType)PatternType.PROCESSING);
        ArrayList ingredients = new ArrayList();
        for (UniversalItemIngredient universalItemIngredient : pattern.inputIngredients()) {
            if (universalItemIngredient.isStack()) {
                stack = universalItemIngredient.stack();
                resourceAmount = new ResourceAmount((com.refinedmods.refinedstorage.api.resource.ResourceKey)new ItemResource(stack.getItem()), (long)stack.getCount());
                ingredients.add(Optional.of(new ProcessingPatternState.ProcessingIngredient(resourceAmount, List.of())));
                continue;
            }
            if (universalItemIngredient.isIngredient()) {
                stack = universalItemIngredient.ingredient().getItems()[0];
                resourceAmount = new ResourceAmount((com.refinedmods.refinedstorage.api.resource.ResourceKey)new ItemResource(stack.getItem()), (long)stack.getCount());
                ingredients.add(Optional.of(new ProcessingPatternState.ProcessingIngredient(resourceAmount, List.of())));
                continue;
            }
            if (universalItemIngredient.isTagIngredient()) {
                tagIngredient = universalItemIngredient.tagIngredient();
                resourceAmount = new ResourceAmount((com.refinedmods.refinedstorage.api.resource.ResourceKey)new ItemResource(universalItemIngredient.primary().getItem()), ((ItemTagIngredient)tagIngredient).amount);
                ingredients.add(Optional.of(new ProcessingPatternState.ProcessingIngredient(resourceAmount, ((ItemTagIngredient)tagIngredient).tags.stream().map(ResourceLocation::parse).toList())));
                continue;
            }
            ingredients.add(Optional.empty());
        }
        for (UniversalFluidIngredient universalFluidIngredient : pattern.inputUniversalFluids()) {
            if (universalFluidIngredient.isStack()) {
                stack = universalFluidIngredient.stack();
                resourceAmount = new ResourceAmount((com.refinedmods.refinedstorage.api.resource.ResourceKey)new FluidResource(stack.getFluid()), (long)stack.getAmount());
                ingredients.add(Optional.of(new ProcessingPatternState.ProcessingIngredient(resourceAmount, List.of())));
                continue;
            }
            if (universalFluidIngredient.isTagIngredient()) {
                tagIngredient = universalFluidIngredient.tagIngredient();
                resourceAmount = new ResourceAmount((com.refinedmods.refinedstorage.api.resource.ResourceKey)new FluidResource(universalFluidIngredient.primary().getFluid()), ((FluidTagIngredient)tagIngredient).amount);
                ingredients.add(Optional.of(new ProcessingPatternState.ProcessingIngredient(resourceAmount, ((FluidTagIngredient)tagIngredient).tags.stream().map(ResourceLocation::parse).toList())));
                continue;
            }
            ingredients.add(Optional.empty());
        }
        ArrayList<Optional<ResourceAmount>> outputs = new ArrayList<Optional<ResourceAmount>>();
        for (UniversalItemIngredient output : pattern.outputIngredients()) {
            ItemStack outputItem = output.primary();
            if (outputItem.isEmpty()) continue;
            outputs.add(Optional.of(new ResourceAmount((com.refinedmods.refinedstorage.api.resource.ResourceKey)new ItemResource(outputItem.getItem()), (long)outputItem.getCount())));
        }
        for (FluidStack outputFluid : pattern.outputFluids()) {
            if (outputFluid.isEmpty()) continue;
            outputs.add(Optional.of(new ResourceAmount((com.refinedmods.refinedstorage.api.resource.ResourceKey)new FluidResource(outputFluid.getFluid()), (long)outputFluid.getAmount())));
        }
        ProcessingPatternState processingPatternState = new ProcessingPatternState(ingredients, outputs);
        unencodedPattern.set(DataComponents.INSTANCE.getProcessingPatternState(), (Object)processingPatternState);
        return unencodedPattern.copy();
    }

    @Override
    public ItemStack writePattern(IUniversalCraftingPattern pattern, Level level) {
        ItemStack unencodedPattern = PatternGridBlockEntity.createPatternStack((PatternType)PatternType.CRAFTING);
        CraftingPatternState state = new CraftingPatternState(pattern.areAllItemsFuzzy(), new CraftingInput.Positioned(pattern.createCraftingInput(), 0, 0));
        unencodedPattern.set(DataComponents.INSTANCE.getCraftingPatternState(), (Object)state);
        return unencodedPattern.copy();
    }

    @Override
    public ItemStack writePattern(IUniversalStonecutterPattern pattern, Level level) {
        ItemStack unencodedPattern = PatternGridBlockEntity.createPatternStack((PatternType)PatternType.STONECUTTER);
        StonecutterPatternState state = new StonecutterPatternState(ItemResource.ofItemStack((ItemStack)pattern.input().primary()), ItemResource.ofItemStack((ItemStack)pattern.getPrimaryOutputStack()));
        unencodedPattern.set(DataComponents.INSTANCE.getStonecutterPatternState(), (Object)state);
        return unencodedPattern.copy();
    }

    @Override
    public ItemStack writePattern(IUniversalSmithingPattern pattern, Level level) {
        ItemStack unencodedPattern = PatternGridBlockEntity.createPatternStack((PatternType)PatternType.SMITHING_TABLE);
        SmithingTablePatternState state = new SmithingTablePatternState(ItemResource.ofItemStack((ItemStack)pattern.getTemplate().primary()), ItemResource.ofItemStack((ItemStack)pattern.getBase().primary()), ItemResource.ofItemStack((ItemStack)pattern.getAddition().primary()));
        unencodedPattern.set(DataComponents.INSTANCE.getSmithingTablePatternState(), (Object)state);
        return unencodedPattern.copy();
    }
}

