/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.mods;

import com.davenonymous.patternconverter.PatternConverter;
import com.davenonymous.patternconverter.api.plugin.IPatternConverter;
import com.davenonymous.patternconverter.api.plugin.PatternConverterSupport;
import com.davenonymous.patternconverter.mods.ConverterStyle;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;

public class PluginLoader {
    public static List<IPatternConverter> converters = new ArrayList<IPatternConverter>();
    public static Map<String, IPatternConverter> converterMap = new HashMap<String, IPatternConverter>();

    public static ConverterStyle getPatternConverterStyle(ItemStack stack, Level level) {
        for (Map.Entry<String, IPatternConverter> converterEntry : converterMap.entrySet()) {
            IPatternConverter converter = converterEntry.getValue();
            String modId = converterEntry.getKey();
            if (!converter.isPattern(stack, level)) continue;
            return ConverterStyle.byMod(modId);
        }
        return ConverterStyle.DEFAULT;
    }

    public static Optional<IPatternConverter> getPatternConverter(ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        for (IPatternConverter converter : converters) {
            if (!converter.isPattern(stack, level)) continue;
            return Optional.of(converter);
        }
        return Optional.empty();
    }

    public static void loadPlugins() {
        converters.clear();
        for (ModFileScanData scanData : ModList.get().getAllScanData()) {
            scanData.getAnnotatedBy(PatternConverterSupport.class, ElementType.TYPE).forEach(annotationData -> {
                Object modId = annotationData.annotationData().get("modid");
                if (!(modId instanceof String)) {
                    return;
                }
                String modid = (String)modId;
                if (!ModList.get().isLoaded(modid)) {
                    PatternConverter.LOGGER.debug("Skipping Pattern Converter support for mod '{}'. It is not loaded.", (Object)modid);
                    return;
                }
                try {
                    Class<?> clazz = Class.forName(annotationData.clazz().getClassName());
                    IPatternConverter converter = (IPatternConverter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    converters.add(converter);
                    converterMap.put(modid, converter);
                    PatternConverter.LOGGER.info("Loaded @PatternConverterSupport class '{}' for mod '{}'.", (Object)annotationData.clazz().getClassName(), (Object)modid);
                }
                catch (Exception e) {
                    PatternConverter.LOGGER.error("Failed to instantiate @PatternConverterSupport class '{}': {}", (Object)annotationData.clazz().getClassName(), (Object)e);
                }
            });
        }
        if (converters.size() <= 1) {
            PatternConverter.LOGGER.error("No pattern converters found. Disabling functionality.");
        } else {
            PatternConverter.LOGGER.info("Loaded " + converters.size() + " pattern converters.");
        }
    }
}

