/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.mods;

import com.davenonymous.patternconverter.PatternConverter;
import com.davenonymous.patternconverter.api.IUniversalPattern;
import com.davenonymous.patternconverter.api.impl.UniversalSuperPattern;
import com.davenonymous.patternconverter.api.plugin.IPatternConverter;
import com.davenonymous.patternconverter.api.plugin.PatternConverterSupport;
import com.davenonymous.patternconverter.api.types.IUniversalCraftingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalProcessingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalSmithingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalStonecutterPattern;
import com.davenonymous.patternconverter.api.wrapper.ItemTagIngredient;
import com.davenonymous.patternconverter.api.wrapper.TagMatchingMode;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.IntegratedDynamicsAPI;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHolder;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;

@PatternConverterSupport(modid="integrateddynamics")
public class IntegratedDynamics
implements IPatternConverter {
    @Override
    public Item patternItem() {
        return (Item)RegistryEntries.ITEM_VARIABLE.get();
    }

    @Override
    public Optional<ResourceKey<CreativeModeTab>> creativeTab() {
        ResourceLocation dynamicsTabId = ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"default");
        CreativeModeTab tab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(dynamicsTabId);
        if (tab == null) {
            PatternConverter.LOGGER.warn("Integrated Dynamics creative mode tab not found: " + String.valueOf(dynamicsTabId));
            return Optional.empty();
        }
        return BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey((Object)tab);
    }

    private IVariableFacade getVariableFacade(ItemStack stack, Level level) {
        IVariableFacadeHolder variableFacadeCap = (IVariableFacadeHolder)stack.getCapability(Capabilities.VariableFacade.ITEM);
        if (variableFacadeCap == null) {
            return null;
        }
        return variableFacadeCap.getVariableFacade(ValueDeseralizationContext.of((Level)level));
    }

    @Override
    public boolean isEmptyPattern(ItemStack stack, Level level) {
        IVariableFacade variableFacade = this.getVariableFacade(stack, level);
        if (variableFacade == null) {
            return true;
        }
        return variableFacade.getId() == -1;
    }

    @Override
    public IUniversalPattern readPattern(ItemStack stack, Level level) {
        IVariableFacade variableFacade = this.getVariableFacade(stack, level);
        if (variableFacade == null) {
            return null;
        }
        if (!(variableFacade instanceof ValueTypeVariableFacade)) {
            return null;
        }
        ValueTypeVariableFacade valueTypeVariableFacade = (ValueTypeVariableFacade)variableFacade;
        IValueType outputType = valueTypeVariableFacade.getOutputType();
        if (!(outputType instanceof ValueObjectTypeRecipe)) {
            return null;
        }
        IValue iValue = valueTypeVariableFacade.getValue();
        if (!(iValue instanceof ValueObjectTypeRecipe.ValueRecipe)) {
            return null;
        }
        ValueObjectTypeRecipe.ValueRecipe valueRecipe = (ValueObjectTypeRecipe.ValueRecipe)iValue;
        Optional optRecipe = valueRecipe.getRawValue();
        if (optRecipe.isEmpty()) {
            return null;
        }
        IRecipeDefinition recipe = (IRecipeDefinition)optRecipe.get();
        UniversalSuperPattern result = new UniversalSuperPattern();
        IMixedIngredients output = recipe.getOutput();
        for (IngredientComponent component : output.getComponents()) {
            for (Object componentEntry : output.getInstances(component)) {
                if (componentEntry instanceof ItemStack) {
                    ItemStack outputStack = (ItemStack)componentEntry;
                    result.addOutput(outputStack);
                    continue;
                }
                if (componentEntry instanceof FluidStack) {
                    FluidStack outputFluid = (FluidStack)componentEntry;
                    result.addOutput(outputFluid);
                    continue;
                }
                if (!component.getName().toString().equals("minecraft:energy") || !(componentEntry instanceof Long)) continue;
                Long energyAmount = (Long)componentEntry;
                result.addOutputEnergy(energyAmount);
            }
        }
        int slot = 0;
        for (IngredientComponent component : recipe.getInputComponents()) {
            block8: for (IPrototypedIngredientAlternatives componentPrototype : recipe.getInputs(component)) {
                if (componentPrototype instanceof PrototypedIngredientAlternativesItemStackTag) {
                    ItemStack representativeItem;
                    Optional firstAlternative;
                    PrototypedIngredientAlternativesItemStackTag itemStackTagComponentPrototype = (PrototypedIngredientAlternativesItemStackTag)componentPrototype;
                    List tags = itemStackTagComponentPrototype.getKeys();
                    TagMatchingMode mode = TagMatchingMode.ANY;
                    if (itemStackTagComponentPrototype.getMatchCondition().intValue() == tags.size()) {
                        mode = TagMatchingMode.ALL;
                    } else if (itemStackTagComponentPrototype.getMatchCondition() <= 0) {
                        mode = TagMatchingMode.NONE;
                    }
                    ItemTagIngredient itemTagIngredient = new ItemTagIngredient(mode, (List<String>)tags);
                    if (!itemStackTagComponentPrototype.getAlternatives().isEmpty() && (firstAlternative = itemStackTagComponentPrototype.getAlternatives().stream().findFirst()).isPresent() && (representativeItem = (ItemStack)((IPrototypedIngredient)firstAlternative.get()).getPrototype()) instanceof ItemStack) {
                        ItemStack representativeStack = representativeItem;
                        itemTagIngredient.setRepresentativeItem(representativeStack);
                    }
                    result.addInput(slot++, itemTagIngredient);
                    continue;
                }
                Optional firstAlternative = componentPrototype.getAlternatives().stream().findFirst();
                if (firstAlternative.isEmpty()) continue;
                Object componentEntry = ((IPrototypedIngredient)firstAlternative.get()).getPrototype();
                Objects.requireNonNull(componentEntry);
                int n = 0;
                block9: while (true) {
                    Object object;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemStack.class, FluidStack.class, Long.class}, (Object)object, n)) {
                        case 0: {
                            ItemStack inputStack = (ItemStack)object;
                            result.addInput(slot++, inputStack);
                            continue block8;
                        }
                        case 1: {
                            FluidStack inputFluid = (FluidStack)object;
                            result.addInput(inputFluid);
                            continue block8;
                        }
                        case 2: {
                            Long energyAmount = (Long)object;
                            if (!component.getName().toString().equals("minecraft:energy")) {
                                n = 3;
                                continue block9;
                            }
                            result.addInputEnergy(energyAmount);
                            continue block8;
                        }
                    }
                    break;
                }
                PatternConverter.LOGGER.warn("Unknown input component type: " + componentEntry.getClass().getName() + " with value: " + String.valueOf(componentEntry));
                return null;
            }
        }
        return result.guessRecipe(level).orElse(null);
    }

    @Override
    public ItemStack writePattern(IUniversalProcessingPattern pattern, Level level) {
        Object outputList;
        PrototypedIngredientAlternativesItemStackTag tagAlternatives;
        FluidStack inputFluid;
        List inputList;
        HashMap<IngredientComponent, List> inputs = new HashMap<IngredientComponent, List>();
        HashMap inputsReusable = new HashMap();
        HashMap<IngredientComponent, List> outputs = new HashMap<IngredientComponent, List>();
        if (pattern.inputEnergy() > 0L) {
            inputList = inputs.computeIfAbsent(IngredientComponent.ENERGY, k -> new ArrayList());
            PrototypedIngredient energy = new PrototypedIngredient(IngredientComponent.ENERGY, (Object)pattern.inputEnergy(), (Object)true);
            PrototypedIngredientAlternativesList energyAlternatives = new PrototypedIngredientAlternativesList(List.of(energy));
            inputList.add(energyAlternatives);
        }
        if (pattern.inputFluids().size() == 1 && !(inputFluid = pattern.inputFluids().getFirst()).isEmpty()) {
            List inputList2 = inputs.computeIfAbsent(IngredientComponent.FLUIDSTACK, k -> new ArrayList());
            PrototypedIngredientAlternativesList fluidAlternatives = new PrototypedIngredientAlternativesList(List.of(new PrototypedIngredient(IngredientComponent.FLUIDSTACK, (Object)inputFluid, (Object)0)));
            inputList2.add(fluidAlternatives);
        }
        if (pattern.inputFluids().size() > 1) {
            PatternConverter.LOGGER.warn("Multiple fluid inputs are not supported in Integrated Dynamics patterns. Only the first one will be used.");
        }
        inputList = inputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
        for (UniversalItemIngredient itemIngredient : pattern.inputIngredients()) {
            if (itemIngredient.isTagIngredient()) {
                ItemTagIngredient inputTag = itemIngredient.tagIngredient();
                tagAlternatives = new PrototypedIngredientAlternativesItemStackTag(inputTag.tags, Integer.valueOf(this.getMatchCondition(inputTag.mode, inputTag.tags)), inputTag.amount);
                inputList.add(tagAlternatives);
                continue;
            }
            PrototypedIngredientAlternativesList itemAlternatives = new PrototypedIngredientAlternativesList(List.of(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)itemIngredient.primary(), (Object)1)));
            inputList.add(itemAlternatives);
        }
        if (pattern.outputEnergy() > 0L) {
            outputList = outputs.computeIfAbsent(IngredientComponent.ENERGY, k -> new ArrayList());
            outputList.add(pattern.outputEnergy());
        }
        for (UniversalItemIngredient outputItemIngredient : pattern.outputIngredients()) {
            if (outputItemIngredient.isTagIngredient()) {
                ItemTagIngredient outputTag = outputItemIngredient.tagIngredient();
                tagAlternatives = new PrototypedIngredientAlternativesItemStackTag(outputTag.tags, Integer.valueOf(this.getMatchCondition(outputTag.mode, outputTag.tags)), outputTag.amount);
                List outputList2 = outputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
                outputList2.add(tagAlternatives);
                continue;
            }
            List outputList3 = outputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
            outputList3.add(outputItemIngredient.primary());
        }
        if (!pattern.outputFluids().isEmpty()) {
            outputList = outputs.computeIfAbsent(IngredientComponent.FLUIDSTACK, k -> new ArrayList());
            for (FluidStack outputFluid : pattern.outputFluids()) {
                if (outputFluid.isEmpty()) continue;
                outputList.add(outputFluid);
            }
        }
        RecipeDefinition recipeDefinition = new RecipeDefinition(inputs, inputsReusable, (IMixedIngredients)new MixedIngredients(outputs));
        return this.writePattern((IRecipeDefinition)recipeDefinition, level);
    }

    @Override
    public ItemStack writePattern(IUniversalCraftingPattern pattern, Level level) {
        HashMap<IngredientComponent, List> inputs = new HashMap<IngredientComponent, List>();
        HashMap inputsReusable = new HashMap();
        HashMap<IngredientComponent, List> outputs = new HashMap<IngredientComponent, List>();
        List inputList = inputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
        LinkedList<UniversalItemIngredient> inputIngredients = new LinkedList<UniversalItemIngredient>(pattern.getAs3by3());
        while (!inputIngredients.isEmpty()) {
            UniversalItemIngredient lastIngredient = (UniversalItemIngredient)inputIngredients.removeLast();
            if (lastIngredient.isEmpty()) continue;
            inputIngredients.add(lastIngredient);
            break;
        }
        for (UniversalItemIngredient itemIngredient : inputIngredients) {
            PrototypedIngredientAlternativesList itemAlternatives;
            if (itemIngredient.isEmpty()) {
                itemAlternatives = new PrototypedIngredientAlternativesList(List.of(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)1)));
                inputList.add(itemAlternatives);
                continue;
            }
            if (itemIngredient.isTagIngredient()) {
                ItemTagIngredient inputTag = itemIngredient.tagIngredient();
                PrototypedIngredientAlternativesItemStackTag tagAlternatives = new PrototypedIngredientAlternativesItemStackTag(inputTag.tags, Integer.valueOf(this.getMatchCondition(inputTag.mode, inputTag.tags)), inputTag.amount);
                inputList.add(tagAlternatives);
                continue;
            }
            itemAlternatives = new PrototypedIngredientAlternativesList(List.of(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)itemIngredient.primary(), (Object)1)));
            inputList.add(itemAlternatives);
        }
        LinkedList<UniversalItemIngredient> outputIngredients = new LinkedList<UniversalItemIngredient>(pattern.outputIngredients());
        while (!outputIngredients.isEmpty()) {
            UniversalItemIngredient lastIngredient = (UniversalItemIngredient)outputIngredients.removeLast();
            if (lastIngredient.isEmpty()) continue;
            outputIngredients.add(lastIngredient);
            break;
        }
        for (UniversalItemIngredient outputItemIngredient : outputIngredients) {
            if (outputItemIngredient.isTagIngredient()) {
                ItemTagIngredient outputTag = outputItemIngredient.tagIngredient();
                PrototypedIngredientAlternativesItemStackTag tagAlternatives = new PrototypedIngredientAlternativesItemStackTag(outputTag.tags, Integer.valueOf(this.getMatchCondition(outputTag.mode, outputTag.tags)), outputTag.amount);
                List outputList = outputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
                outputList.add(tagAlternatives);
                continue;
            }
            List outputList = outputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
            outputList.add(outputItemIngredient.primary());
        }
        RecipeDefinition recipeDefinition = new RecipeDefinition(inputs, inputsReusable, (IMixedIngredients)new MixedIngredients(outputs));
        return this.writePattern((IRecipeDefinition)recipeDefinition, level);
    }

    @Override
    public ItemStack writePattern(IUniversalStonecutterPattern pattern, Level level) {
        HashMap<IngredientComponent, List> inputs = new HashMap<IngredientComponent, List>();
        HashMap inputsReusable = new HashMap();
        HashMap<IngredientComponent, List> outputs = new HashMap<IngredientComponent, List>();
        List inputList = inputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
        PrototypedIngredientAlternativesList itemAlternatives = new PrototypedIngredientAlternativesList(List.of(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)pattern.input().primary(), (Object)0)));
        inputList.add(itemAlternatives);
        List outputList = outputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
        outputList.add(pattern.getPrimaryOutputStack());
        RecipeDefinition recipeDefinition = new RecipeDefinition(inputs, inputsReusable, (IMixedIngredients)new MixedIngredients(outputs));
        return this.writePattern((IRecipeDefinition)recipeDefinition, level);
    }

    @Override
    public ItemStack writePattern(IUniversalSmithingPattern pattern, Level level) {
        HashMap<IngredientComponent, List> inputs = new HashMap<IngredientComponent, List>();
        HashMap inputsReusable = new HashMap();
        HashMap<IngredientComponent, List> outputs = new HashMap<IngredientComponent, List>();
        List inputList = inputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
        PrototypedIngredientAlternativesList templateAlternatives = new PrototypedIngredientAlternativesList(List.of(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)pattern.getTemplate().primary(), (Object)1)));
        inputList.add(templateAlternatives);
        PrototypedIngredientAlternativesList baseAlternatives = new PrototypedIngredientAlternativesList(List.of(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)pattern.getBase().primary(), (Object)1)));
        inputList.add(baseAlternatives);
        PrototypedIngredientAlternativesList additionAlternatives = new PrototypedIngredientAlternativesList(List.of(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)pattern.getAddition().primary(), (Object)1)));
        inputList.add(additionAlternatives);
        List outputList = outputs.computeIfAbsent(IngredientComponent.ITEMSTACK, k -> new ArrayList());
        outputList.add(pattern.getPrimaryOutputStack());
        RecipeDefinition recipeDefinition = new RecipeDefinition(inputs, inputsReusable, (IMixedIngredients)new MixedIngredients(outputs));
        return this.writePattern((IRecipeDefinition)recipeDefinition, level);
    }

    private int getMatchCondition(TagMatchingMode mode, List<String> tags) {
        if (mode == TagMatchingMode.NONE) {
            return 0;
        }
        if (mode == TagMatchingMode.ANY) {
            return 1;
        }
        if (mode == TagMatchingMode.ALL) {
            return tags.size();
        }
        return -1;
    }

    private ItemStack writePattern(IRecipeDefinition recipeDefinition, Level level) {
        IVariableFacadeHandlerRegistry handlerRegistry = (IVariableFacadeHandlerRegistry)IntegratedDynamicsAPI.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        IValueTypeRegistry valueTypeRegistry = (IValueTypeRegistry)handlerRegistry.getHandler(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"valuetype"));
        if (valueTypeRegistry == null) {
            PatternConverter.LOGGER.warn("Integrated Dynamics ValueTypeRegistry not found. Cannot write pattern.");
            return ItemStack.EMPTY;
        }
        ValueObjectTypeRecipe valueObjectTypeRecipe = (ValueObjectTypeRecipe)valueTypeRegistry.getValueType(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"recipe"));
        ValueObjectTypeRecipe.ValueRecipe valueRecipe = ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)recipeDefinition);
        ValueTypeVariableFacade variableFacade = new ValueTypeVariableFacade(true, (IValueType)valueObjectTypeRecipe, (IValue)valueRecipe);
        return handlerRegistry.writeVariableFacadeItem(new ItemStack((ItemLike)this.patternItem()), (IVariableFacade)variableFacade, (IVariableFacadeHandler)valueTypeRegistry);
    }
}

