/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.mods;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.ids.AEComponents;
import appeng.api.ids.AECreativeTabIds;
import appeng.api.ids.AEItemIds;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.EncodedCraftingPattern;
import appeng.crafting.pattern.EncodedProcessingPattern;
import appeng.crafting.pattern.EncodedSmithingTablePattern;
import appeng.crafting.pattern.EncodedStonecuttingPattern;
import com.davenonymous.patternconverter.PatternConverter;
import com.davenonymous.patternconverter.api.IUniversalPattern;
import com.davenonymous.patternconverter.api.impl.UniversalCraftingPattern;
import com.davenonymous.patternconverter.api.impl.UniversalProcessingPattern;
import com.davenonymous.patternconverter.api.impl.UniversalSmithingPattern;
import com.davenonymous.patternconverter.api.impl.UniversalStonecutterPattern;
import com.davenonymous.patternconverter.api.plugin.IPatternConverter;
import com.davenonymous.patternconverter.api.plugin.PatternConverterSupport;
import com.davenonymous.patternconverter.api.types.IUniversalCraftingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalProcessingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalSmithingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalStonecutterPattern;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

@PatternConverterSupport(modid="ae2")
public class AppliedEnergistics2
implements IPatternConverter {
    @Override
    public Optional<ResourceKey<CreativeModeTab>> creativeTab() {
        return Optional.of(AECreativeTabIds.MAIN);
    }

    @Override
    public Item patternItem() {
        return (Item)BuiltInRegistries.ITEM.get(AEItemIds.BLANK_PATTERN);
    }

    @Override
    public boolean isPattern(ItemStack stack, Level level) {
        Item item = stack.getItem();
        if (item.builtInRegistryHolder().getKey().location().equals((Object)AEItemIds.BLANK_PATTERN)) {
            return true;
        }
        return PatternDetailsHelper.isEncodedPattern((ItemStack)stack);
    }

    @Override
    public boolean isEmptyPattern(ItemStack stack, Level level) {
        IPatternDetails pattern = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)level);
        if (pattern == null) {
            return true;
        }
        return pattern.getOutputs().isEmpty() || pattern.getInputs().length == 0;
    }

    @Override
    public IUniversalPattern readPattern(ItemStack stack, Level level) {
        IPatternDetails pattern = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)level);
        if (pattern == null) {
            return null;
        }
        EncodedCraftingPattern craftingPattern = (EncodedCraftingPattern)pattern.getDefinition().get(AEComponents.ENCODED_CRAFTING_PATTERN);
        if (craftingPattern != null) {
            UniversalCraftingPattern result = new UniversalCraftingPattern();
            result.setAllItemsFuzzy(craftingPattern.canSubstitute());
            result.setAllFluidsFuzzy(craftingPattern.canSubstituteFluids());
            for (int slot = 0; slot < craftingPattern.inputs().size(); ++slot) {
                ItemStack itemStack = (ItemStack)craftingPattern.inputs().get(slot);
                if (itemStack.isEmpty()) continue;
                result.addInput(slot, itemStack.copy());
            }
            result.addOutput(craftingPattern.result().copy());
            Optional recipe = level.getRecipeManager().byKey(craftingPattern.recipeId());
            if (recipe.isPresent() && ((RecipeHolder)recipe.get()).value() instanceof CraftingRecipe) {
                result.setRecipe((RecipeHolder<CraftingRecipe>)((RecipeHolder)recipe.get()));
            }
            return result;
        }
        EncodedSmithingTablePattern smithingPattern = (EncodedSmithingTablePattern)pattern.getDefinition().get(AEComponents.ENCODED_SMITHING_TABLE_PATTERN);
        if (smithingPattern != null) {
            Optional recipe;
            UniversalSmithingPattern result = new UniversalSmithingPattern(smithingPattern.template().copy(), smithingPattern.base().copy(), smithingPattern.addition().copy());
            if (smithingPattern.canSubstitute()) {
                result.setAllItemsFuzzy(true);
            }
            if ((recipe = level.getRecipeManager().byKey(smithingPattern.recipeId())).isPresent() && ((RecipeHolder)recipe.get()).value() instanceof SmithingRecipe) {
                result.setRecipe((RecipeHolder<SmithingRecipe>)((RecipeHolder)recipe.get()));
            }
            result.addOutput(smithingPattern.resultItem());
            return result;
        }
        EncodedStonecuttingPattern stonecuttingPattern = (EncodedStonecuttingPattern)pattern.getDefinition().get(AEComponents.ENCODED_STONECUTTING_PATTERN);
        if (stonecuttingPattern != null) {
            Optional recipe;
            UniversalStonecutterPattern result = new UniversalStonecutterPattern(stonecuttingPattern.input());
            if (stonecuttingPattern.canSubstitute()) {
                result.setAllItemsFuzzy(true);
            }
            if ((recipe = level.getRecipeManager().byKey(stonecuttingPattern.recipeId())).isPresent() && ((RecipeHolder)recipe.get()).value() instanceof StonecutterRecipe) {
                result.setRecipe((RecipeHolder<StonecutterRecipe>)((RecipeHolder)recipe.get()));
            }
            result.addOutput(stonecuttingPattern.output());
            return result;
        }
        EncodedProcessingPattern processingPattern = (EncodedProcessingPattern)pattern.getDefinition().get(AEComponents.ENCODED_PROCESSING_PATTERN);
        if (processingPattern != null) {
            FluidStack fluidStack;
            AEFluidKey aeFluidKey;
            ItemStack itemStack;
            AEItemKey aeItemKey;
            AEKey what;
            UniversalProcessingPattern result = new UniversalProcessingPattern();
            for (GenericStack input : processingPattern.sparseInputs()) {
                if (input == null || input.amount() <= 0L) continue;
                what = input.what();
                if (what instanceof AEItemKey) {
                    aeItemKey = (AEItemKey)what;
                    itemStack = aeItemKey.getReadOnlyStack();
                    result.addInput(itemStack.copy());
                    continue;
                }
                if (!(what instanceof AEFluidKey)) continue;
                aeFluidKey = (AEFluidKey)what;
                fluidStack = aeFluidKey.toStack((int)input.amount());
                result.addInput(fluidStack.copy());
            }
            for (GenericStack output : processingPattern.sparseOutputs()) {
                if (output == null || output.amount() <= 0L) continue;
                what = output.what();
                if (what instanceof AEItemKey) {
                    aeItemKey = (AEItemKey)what;
                    itemStack = aeItemKey.getReadOnlyStack();
                    result.addOutput(itemStack.copy());
                    continue;
                }
                if (what instanceof AEFluidKey) {
                    aeFluidKey = (AEFluidKey)what;
                    fluidStack = aeFluidKey.toStack((int)output.amount());
                    result.addOutput(fluidStack.copy());
                    continue;
                }
                PatternConverter.LOGGER.warn("AE2 pattern output is neither item nor fluid: {}", (Object)what);
            }
            return result;
        }
        return null;
    }

    @Override
    public ItemStack writePattern(IUniversalProcessingPattern pattern, Level level) {
        ArrayList<GenericStack> outputStacks = new ArrayList<GenericStack>();
        ArrayList<GenericStack> inputStacks = new ArrayList<GenericStack>();
        for (UniversalItemIngredient itemIngredient : pattern.inputIngredients()) {
            GenericStack genericStack = GenericStack.fromItemStack((ItemStack)itemIngredient.primary());
            inputStacks.add(genericStack);
        }
        for (FluidStack inputFluid : pattern.inputFluids()) {
            inputStacks.add(GenericStack.fromFluidStack((FluidStack)inputFluid));
        }
        for (UniversalItemIngredient itemIngredient : pattern.outputIngredients()) {
            outputStacks.add(GenericStack.fromItemStack((ItemStack)itemIngredient.primary()));
        }
        for (FluidStack outputFluid : pattern.outputFluids()) {
            outputStacks.add(GenericStack.fromFluidStack((FluidStack)outputFluid));
        }
        if (inputStacks.isEmpty() || outputStacks.isEmpty()) {
            PatternConverter.LOGGER.warn("Cannot write processing pattern, no input or output defined. Returning empty pattern.");
            return ItemStack.EMPTY;
        }
        return PatternDetailsHelper.encodeProcessingPattern(inputStacks, outputStacks);
    }

    @Override
    public ItemStack writePattern(IUniversalCraftingPattern pattern, Level level) {
        if (pattern.craftingRecipe() == null) {
            PatternConverter.LOGGER.warn("Cannot write crafting pattern, no recipe defined. Returning empty pattern.");
            return ItemStack.EMPTY;
        }
        return PatternDetailsHelper.encodeCraftingPattern(pattern.craftingRecipe(), (ItemStack[])((ItemStack[])pattern.getAs3by3().stream().map(UniversalItemIngredient::primary).toArray(ItemStack[]::new)), (ItemStack)pattern.getPrimaryOutputStack(), (boolean)pattern.areAllItemsFuzzy(), (boolean)pattern.areAllFluidsFuzzy());
    }

    @Override
    public ItemStack writePattern(IUniversalStonecutterPattern pattern, Level level) {
        if (pattern.stoneCutterRecipe() == null) {
            PatternConverter.LOGGER.warn("Cannot write stonecutter pattern, no recipe defined. Returning empty pattern.");
            return ItemStack.EMPTY;
        }
        return PatternDetailsHelper.encodeStonecuttingPattern(pattern.stoneCutterRecipe(), (AEItemKey)AEItemKey.of((ItemStack)pattern.input().primary()), (AEItemKey)AEItemKey.of((ItemStack)pattern.getPrimaryOutputStack()), (boolean)pattern.areAllItemsFuzzy());
    }

    @Override
    public ItemStack writePattern(IUniversalSmithingPattern pattern, Level level) {
        if (pattern.smithingRecipe() == null) {
            PatternConverter.LOGGER.warn("Cannot write smithing pattern, no recipe defined. Returning empty pattern.");
            return ItemStack.EMPTY;
        }
        return PatternDetailsHelper.encodeSmithingTablePattern(pattern.smithingRecipe(), (AEItemKey)AEItemKey.of((ItemStack)pattern.getTemplate().primary()), (AEItemKey)AEItemKey.of((ItemStack)pattern.getBase().primary()), (AEItemKey)AEItemKey.of((ItemStack)pattern.getAddition().primary()), (AEItemKey)AEItemKey.of((ItemStack)pattern.getPrimaryOutputStack()), (boolean)pattern.areAllItemsFuzzy());
    }
}

