/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets.layout;

import com.davenonymous.patternconverter.lib.gui.event.VisibilityChangedEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class FlexSizer
extends WidgetPanel {
    Map<Integer, Integer> flexValues;
    Map<Integer, FlexMode> flexModes;
    Map<Integer, Widget> flexWidgets;
    Map<Integer, Integer> realBoxOffsets;
    Map<Integer, Integer> realBoxSize;
    FlexAlign flexAlign = FlexAlign.START;
    FlexDirection flexDirection = FlexDirection.X;
    int padding = 0;

    public FlexSizer() {
        this.flexWidgets = new HashMap<Integer, Widget>();
        this.flexValues = new HashMap<Integer, Integer>();
        this.flexModes = new HashMap<Integer, FlexMode>();
        this.realBoxOffsets = new HashMap<Integer, Integer>();
        this.realBoxSize = new HashMap<Integer, Integer>();
        this.addListener(WidgetSizeChangeEvent.class, (event, widget) -> {
            this.update(this);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public boolean isHorizontal() {
        return this.flexDirection == FlexDirection.X;
    }

    public boolean isVertical() {
        return this.flexDirection == FlexDirection.Y;
    }

    public FlexSizer setFlexDirection(FlexDirection direction) {
        this.flexDirection = direction;
        return this;
    }

    public FlexSizer setFlexAlign(FlexAlign alignment) {
        this.flexAlign = alignment;
        return this;
    }

    public FlexSizer setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public FlexSizer addFixedBox(Widget box, int size) {
        return this.addBox(box, FlexMode.FIXED, size);
    }

    public FlexSizer addFlexBox(Widget box, int flexWeight) {
        return this.addBox(box, FlexMode.FLEX, flexWeight);
    }

    public FlexSizer addContentBox(Widget box) {
        box.addListener(WidgetSizeChangeEvent.class, (event, widget) -> {
            if (event.xChanged() && this.isHorizontal()) {
                this.update(widget);
            } else if (event.yChanged() && this.isVertical()) {
                this.update(widget);
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        return this.addBox(box, FlexMode.CONTENT, 0);
    }

    private FlexSizer addBox(Widget box, FlexMode mode, int value) {
        this.flexValues.put(this.flexValues.size(), value);
        this.flexModes.put(this.flexModes.size(), mode);
        this.flexWidgets.put(this.flexWidgets.size(), box);
        this.update(null);
        if (this.isHorizontal()) {
            box.y = 0;
            box.height = this.height;
        } else {
            box.x = 0;
            box.width = this.width;
        }
        this.add(box);
        this.update(null);
        box.addListener(VisibilityChangedEvent.class, (event, widget) -> {
            this.update(null);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        return this;
    }

    public FlexSizer setFlex(int boxNum, int value) {
        this.flexValues.put(boxNum, value);
        return this;
    }

    public FlexSizer setFlexMode(int boxNum, FlexMode mode) {
        this.flexModes.put(boxNum, mode);
        return this;
    }

    public FlexSizer update(@Nullable Widget trigger) {
        int totalFlexWeight = 0;
        int totalFixedPx = 0;
        int totalContentPx = 0;
        int totalPadding = (this.flexWidgets.size() - 1) * this.padding;
        for (Map.Entry<Integer, FlexMode> entry : this.flexModes.entrySet()) {
            int columnIndex = entry.getKey();
            if (!this.flexWidgets.get(columnIndex).isVisible()) continue;
            int value = this.flexValues.get(columnIndex);
            switch (entry.getValue().ordinal()) {
                case 0: {
                    totalFixedPx += value;
                    break;
                }
                case 1: {
                    totalFlexWeight += value;
                    break;
                }
                case 2: {
                    Widget box = this.flexWidgets.get(columnIndex);
                    totalContentPx += this.isHorizontal() ? box.width : box.height;
                }
            }
        }
        int thisSize = this.isHorizontal() ? this.width : this.height;
        int remainingPx = thisSize - totalFixedPx - totalContentPx - totalPadding;
        int pxPerFlex = totalFlexWeight > 0 ? remainingPx / totalFlexWeight : 0;
        int offset = 0;
        for (Map.Entry<Integer, Integer> entry : this.flexValues.entrySet()) {
            int columnIndex = entry.getKey();
            int value = entry.getValue();
            Widget box = this.flexWidgets.get(columnIndex);
            if (!box.isVisible()) continue;
            switch (this.flexModes.get(columnIndex).ordinal()) {
                case 0: {
                    this.realBoxSize.put(columnIndex, value);
                    this.realBoxOffsets.put(columnIndex, offset);
                    offset += value + this.padding;
                    break;
                }
                case 1: {
                    int flexPx = value * pxPerFlex;
                    this.realBoxSize.put(columnIndex, flexPx);
                    this.realBoxOffsets.put(columnIndex, offset);
                    offset += flexPx + this.padding;
                    break;
                }
                case 2: {
                    int contentPx = this.isHorizontal() ? box.width : box.height;
                    this.realBoxSize.put(columnIndex, contentPx);
                    this.realBoxOffsets.put(columnIndex, offset);
                    offset += contentPx + this.padding;
                }
            }
            if (trigger != null && trigger == box) continue;
            if (this.flexDirection == FlexDirection.X) {
                box.x = this.realBoxOffsets.get(columnIndex);
                box.width = this.realBoxSize.get(columnIndex);
                box.height = this.height;
                continue;
            }
            box.y = this.realBoxOffsets.get(columnIndex);
            box.height = this.realBoxSize.get(columnIndex);
            box.width = this.width;
        }
        return this;
    }

    public static enum FlexAlign {
        START,
        CENTER,
        END;

    }

    public static enum FlexDirection {
        X,
        Y;

    }

    public static enum FlexMode {
        FIXED,
        FLEX,
        CONTENT;

    }
}

