/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanelWithValue;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class WidgetZoomPanel
extends WidgetPanelWithValue<Widget> {
    public float zoomFactor = 1.0f;

    public WidgetZoomPanel(Widget value) {
        super(value);
        this.eventListeners.clear();
        this.anyEventListener.clear();
        this.renderDebugOutlines = true;
        this.setDimensions(0, 0, value.width, value.height);
        this.add(value);
    }

    @Override
    public void draw(GuiGraphics guiGraphics, Screen screen) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(this.zoomFactor, this.zoomFactor, 1.0f);
        super.draw(guiGraphics, screen);
        guiGraphics.pose().popPose();
    }

    @Override
    public Widget getHoveredWidget(int mouseX, int mouseY) {
        int scaledMouseX = Math.round((float)this.getMouseX() / this.zoomFactor);
        int scaledMouseY = Math.round((float)this.getMouseY() / this.zoomFactor);
        return super.getHoveredWidget(scaledMouseX, scaledMouseY);
    }
}

