/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.ISelectable;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetLabel;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import java.util.function.Function;
import net.minecraft.network.chat.Style;

public class WidgetWithLabel<T extends Widget>
extends WidgetPanel
implements ISelectable {
    T widget;
    WidgetLabel label;
    int labelXOffset = 0;
    int labelYOffset = 0;

    public WidgetWithLabel(T pWidget, String labelText) {
        this.widget = pWidget;
        ((Widget)this.widget).setPosition(0, 0);
        this.label = new WidgetLabel(labelText);
        this.add(this.label);
        this.add((Widget)this.widget);
        this.addListener(WidgetSizeChangeEvent.class, (event, ignored) -> {
            this.label.setX(((Widget)this.widget).width + 2 + this.labelXOffset);
            this.label.setY((((Widget)this.widget).height - (this.label.height - 2)) / 2 + this.labelYOffset);
            this.label.setWidth(this.width - ((Widget)this.widget).width - 2 - this.labelXOffset);
            return WidgetEventResult.HANDLED;
        });
    }

    public WidgetLabel label() {
        return this.label;
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void applyLabelStyle(Function<Style, Style> styleSetter) {
        this.label.applyStyle(styleSetter);
    }

    public WidgetWithLabel<T> setLabelOffset(int labelXOffset, int labelYOffset) {
        this.labelXOffset = labelXOffset;
        this.labelYOffset = labelYOffset;
        return this;
    }

    public WidgetWithLabel<T> setLabelXOffset(int labelXOffset) {
        this.labelXOffset = labelXOffset;
        return this;
    }

    public WidgetWithLabel<T> setLabelYOffset(int labelYOffset) {
        this.labelYOffset = labelYOffset;
        return this;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void setSelected(boolean state) {
    }
}

