/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.CircularPointedArrayList;
import com.davenonymous.patternconverter.lib.gui.IClientTooltipProvider;
import com.davenonymous.patternconverter.lib.gui.event.MouseClickEvent;
import com.davenonymous.patternconverter.lib.gui.event.ValueChangedEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import java.util.Collection;
import java.util.Collections;

public class WidgetWithChoiceValue<T>
extends Widget {
    CircularPointedArrayList<T> choices = new CircularPointedArrayList();

    public T getValue() {
        return this.choices.getPointedElement();
    }

    public void setValue(T choice) {
        this.setValue(choice, true);
    }

    public void setValue(T choice, boolean fireEvent) {
        T oldValue = this.choices.getPointedElement();
        this.choices.setPointerTo(choice);
        if (choice instanceof IClientTooltipProvider) {
            IClientTooltipProvider tooltipProvider = (IClientTooltipProvider)choice;
            this.setTooltipElements(tooltipProvider.getClientTooltip());
        }
        if (fireEvent) {
            this.fireEvent(new ValueChangedEvent<T>(oldValue, choice));
        }
    }

    public void addChoice(T ... newChoices) {
        Collections.addAll(this.choices, newChoices);
    }

    public void addChoiceFromArray(T[] newChoices) {
        Collections.addAll(this.choices, newChoices);
    }

    public void addChoice(Collection<T> newChoices) {
        this.choices.addAll(newChoices);
    }

    public void next() {
        T oldValue = this.choices.getPointedElement();
        T newValue = this.choices.next();
        if (newValue instanceof IClientTooltipProvider) {
            IClientTooltipProvider tooltipProvider = (IClientTooltipProvider)newValue;
            this.setTooltipElements(tooltipProvider.getClientTooltip());
        }
        this.fireEvent(new ValueChangedEvent<T>(oldValue, newValue));
    }

    public void prev() {
        T oldValue = this.choices.getPointedElement();
        T newValue = this.choices.prev();
        if (newValue instanceof IClientTooltipProvider) {
            IClientTooltipProvider tooltipProvider = (IClientTooltipProvider)newValue;
            this.setTooltipElements(tooltipProvider.getClientTooltip());
        }
        this.fireEvent(new ValueChangedEvent<T>(oldValue, newValue));
    }

    public void addClickListener() {
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            if (event.isLeftClick()) {
                ((WidgetWithChoiceValue)widget).next();
            } else {
                ((WidgetWithChoiceValue)widget).prev();
            }
            return WidgetEventResult.HANDLED;
        });
    }
}

