/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.ISelectable;
import com.davenonymous.patternconverter.lib.gui.event.ListEntrySelectionEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseClickEvent;
import com.davenonymous.patternconverter.lib.gui.event.ValueChangedEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.tooltip.WrappedStringTooltipComponent;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetTextBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;

public class WidgetTreeNode {
    Widget widget;
    private boolean expanded;
    List<WidgetTreeNode> children;
    private TreeNodeEntryPanel indentedBox = null;
    private Widget expansionButton = null;
    private int indentPixels = 10;
    private Supplier<Widget> buttonProvider = null;

    public WidgetTreeNode(Widget widget) {
        this.widget = widget;
        this.expanded = false;
        this.children = new ArrayList<WidgetTreeNode>();
    }

    public WidgetTreeNode setIndentPixels(int indentPixels) {
        this.indentPixels = indentPixels;
        return this;
    }

    public Widget widget() {
        return this.widget;
    }

    public WidgetTreeNode addChild(Widget widget) {
        WidgetTreeNode node = new WidgetTreeNode(widget);
        node.setIndentPixels(this.indentPixels);
        this.children.add(node);
        return node;
    }

    public WidgetTreeNode setExpanded(boolean expanded) {
        this.expanded = expanded;
        if (this.expansionButton != null) {
            this.expansionButton.fireEvent(new ValueChangedEvent<Boolean>(!expanded, expanded));
        }
        return this;
    }

    public Widget expansionButton() {
        return this.expansionButton;
    }

    public WidgetTreeNode setExtensionButtonProvider(Supplier<Widget> buttonProvider) {
        this.buttonProvider = buttonProvider;
        return this;
    }

    public TreeNodeEntryPanel getIndented(int indentLevel, int maxWidth) {
        TreeNodeEntryPanel box = new TreeNodeEntryPanel(this);
        box.setWidth(maxWidth);
        box.setHeight(this.widget.height);
        this.widget.setWidth(maxWidth - this.indentPixels * (indentLevel + 1));
        Widget widget = this.widget;
        if (widget instanceof WidgetTextBox) {
            WidgetTextBox tb = (WidgetTextBox)widget;
            tb.autoWidth();
            if (tb.width > maxWidth - this.indentPixels * (indentLevel + 1)) {
                this.widget.setWidth(maxWidth - this.indentPixels * (indentLevel + 1));
            }
        }
        boolean canExpand = !this.children.isEmpty();
        int expandButtonWidth = 0;
        if (canExpand) {
            Widget expander;
            if (this.buttonProvider != null) {
                expander = this.buttonProvider.get();
            } else {
                WidgetTextBox textButton = new WidgetTextBox(this.expanded ? "-" : "+");
                textButton.setStyle(style -> style.withColor(ChatFormatting.DARK_GRAY));
                textButton.setSize(8, 10);
                textButton.addListener(ValueChangedEvent.class, (event, widget1) -> {
                    Boolean newValue;
                    Object patt0$temp = event.newValue;
                    if (patt0$temp instanceof Boolean && (newValue = (Boolean)patt0$temp).booleanValue()) {
                        textButton.setText("-");
                    } else {
                        textButton.setText("+");
                    }
                    return WidgetEventResult.HANDLED;
                });
                expander = textButton;
            }
            expandButtonWidth = expander.width;
            int expanderYOffset = (this.widget.height + 4 - expander.height) / 2;
            expander.setPosition(this.indentPixels * indentLevel, expanderYOffset);
            box.add(expander);
            if (this.count() <= 256) {
                expander.addListener(MouseClickEvent.class, (event, widget1) -> {
                    this.setExpanded(!this.expanded);
                    box.fireEvent(new ValueChangedEvent<Boolean>(!this.expanded, this.expanded));
                    return WidgetEventResult.HANDLED;
                });
            } else {
                expander.setTooltipElements(WrappedStringTooltipComponent.yellow(I18n.get((String)"patternconverter.gui.files.overflow.label", (Object[])new Object[0])), WrappedStringTooltipComponent.gray(I18n.get((String)"patternconverter.gui.files.overflow.tooltip", (Object[])new Object[]{this.count()})));
            }
            box.add(expander);
            this.expansionButton = expander;
        }
        this.widget.setPosition(expandButtonWidth + this.indentPixels * indentLevel, 2);
        box.add(this.widget);
        this.indentedBox = box;
        return this.indentedBox;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int count() {
        return this.children.size();
    }

    public static class TreeNodeEntryPanel
    extends WidgetPanel
    implements ISelectable {
        private boolean selected = false;
        private WidgetTreeNode node;

        public TreeNodeEntryPanel(WidgetTreeNode node) {
            this.node = node;
            this.addListener(WidgetSizeChangeEvent.class, (event, widget) -> {
                node.widget.setWidth(event.newWidth());
                return WidgetEventResult.CONTINUE_PROCESSING;
            });
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean state) {
            this.selected = state;
            this.node.widget().fireEvent(new ListEntrySelectionEvent(state));
        }

        public WidgetTreeNode node() {
            return this.node;
        }
    }
}

