/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.GUIHelper;
import com.davenonymous.patternconverter.lib.gui.event.TabChangedEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetTabsButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WidgetTabsPanel
extends WidgetPanel {
    protected final List<WidgetPanel> pages = new ArrayList<WidgetPanel>();
    protected final Map<WidgetPanel, Widget> pageButtonWidget = new HashMap<WidgetPanel, Widget>();
    protected final Map<WidgetPanel, List<Component>> pageTooltips = new HashMap<WidgetPanel, List<Component>>();
    protected TabDockEdge edge = TabDockEdge.WEST;
    protected WidgetPanel activePanel = null;
    protected WidgetPanel buttonsPanel = new WidgetPanel();

    public WidgetTabsPanel() {
        this.buttonsPanel.setSize(200, 32);
        this.add(this.buttonsPanel);
        this.addListener(WidgetSizeChangeEvent.class, (event, widget) -> {
            this.buttonsPanel.setDimensions(0, 0, event.newWidth(), 32);
            for (WidgetPanel page : this.pages) {
                page.setWidth(this.width);
                page.setHeight(this.height - 32);
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public WidgetTabsPanel setEdge(TabDockEdge edge) {
        this.edge = edge;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.pages.clear();
        this.pageButtonWidget.clear();
        this.pageTooltips.clear();
        this.children.clear();
        this.add(this.buttonsPanel);
    }

    public void addPage(WidgetPanel panel, Widget buttonStack) {
        this.addPage(panel, buttonStack, null);
    }

    public void addPage(WidgetPanel panel, Widget buttonStack, List<Component> tooltip) {
        panel.setWidth(this.width);
        panel.setHeight(this.height - 32);
        panel.setY(32);
        panel.parent = this;
        this.pages.add(panel);
        this.pageButtonWidget.put(panel, buttonStack);
        if (this.activePanel == null) {
            this.activePanel = panel;
            this.activePanel.setVisible(true);
        } else {
            panel.setVisible(false);
        }
        if (tooltip != null) {
            this.pageTooltips.put(panel, tooltip);
        }
        this.add(panel);
        this.updateButtonsPanel();
    }

    public void setActivePage(WidgetPanel page) {
        if (!this.pages.contains(page)) {
            return;
        }
        this.setActivePage(this.pages.indexOf(page));
    }

    public void setActivePage(int page) {
        if (page < 0 || page >= this.pages.size()) {
            return;
        }
        WidgetPanel oldPage = this.activePanel;
        WidgetPanel newPage = this.pages.get(page);
        this.activePanel.setVisible(false);
        newPage.setVisible(true);
        this.activePanel = newPage;
        this.fireEvent(new TabChangedEvent(oldPage, newPage));
    }

    public void updateButtonsPanel() {
        this.buttonsPanel.clear();
        int y = 0;
        int x = this.edge == TabDockEdge.NORTH ? 4 : 0;
        for (WidgetPanel page : this.pages) {
            WidgetTabsButton button = new WidgetTabsButton(this, page, this.pageButtonWidget.get(page), this.edge);
            button.setPosition(x, y);
            switch (this.edge.ordinal()) {
                default: {
                    button.setSize(32, 28);
                    y += 28;
                    break;
                }
                case 1: {
                    button.setSize(31, 32);
                    x += 31;
                }
            }
            this.buttonsPanel.add(button);
            if (!this.pageTooltips.containsKey(page)) continue;
            button.addTooltipLine(this.pageTooltips.get(page));
        }
    }

    @Override
    public void draw(GuiGraphics guiGraphics, Screen screen) {
        GUIHelper.drawWindow(guiGraphics, this.width, this.height - 28, false, this.x - 9, this.y + 19);
        super.draw(guiGraphics, screen);
    }

    public static enum TabDockEdge {
        WEST,
        NORTH;

    }
}

