/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.CellData;
import com.davenonymous.patternconverter.lib.gui.GUI;
import com.davenonymous.patternconverter.lib.gui.event.MouseDraggedEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseReleasedEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseScrollEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec2;

public class WidgetTable
extends WidgetPanel {
    Table<Integer, Integer, CellData> table;
    int cellPadding = 0;
    public boolean alwaysShowFirstColumn = true;
    public boolean alwaysShowFirstRow = true;
    private int rowOffset = 0;
    private int colOffset = 0;
    private int visibleRows = 0;
    private int visibleColumns = 0;
    private int visibleHeight = 0;
    private int visibleWidth = 0;
    private int totalRows = 0;
    private int totalColumns = 0;
    private int scrollBarDimension = 8;
    Vec2 dragStart = new Vec2(0.0f, 0.0f);

    public WidgetTable() {
        this.table = TreeBasedTable.create();
        this.addListener(WidgetSizeChangeEvent.class, (event, widget) -> {
            this.repositionCells();
            return WidgetEventResult.HANDLED;
        });
        this.addListener(MouseScrollEvent.class, (event, widget) -> {
            if (!this.areAllParentsVisible()) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            if (widget.isPosInside(event.mouseX, event.mouseY)) {
                GUI gui = this.getGUI();
                boolean horizontal = gui.isCtrlDown();
                int scrollValue = Math.abs((int)Math.ceil(event.rawScrollValue));
                if (event.up) {
                    if (horizontal) {
                        this.scrollLeft(scrollValue);
                    } else {
                        this.scrollUp(scrollValue);
                    }
                } else if (horizontal) {
                    this.scrollRight(scrollValue);
                } else {
                    this.scrollDown(scrollValue);
                }
                return WidgetEventResult.HANDLED;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseReleasedEvent.class, (event, widget) -> {
            this.getGUI().setDragging(false);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseDraggedEvent.class, (event, widget) -> {
            int scrollBarWidth;
            float xRatio;
            int newXOffset;
            double mouseY;
            double mouseX;
            if (!this.getGUI().isDragging()) {
                this.getGUI().setDragging(true);
                this.dragStart = new Vec2((float)event.mouseX(), (float)event.mouseY());
            }
            if (!this.isPosInside(mouseX = event.mouseX(), mouseY = event.mouseY())) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            int scrollBarY = this.getActualY();
            int scrollBarX = this.getActualX();
            if (this.alwaysShowFirstRow) {
                mouseY -= (double)this.getRowHeight(0);
                scrollBarY -= this.getRowHeight(0);
            }
            if (this.alwaysShowFirstColumn) {
                mouseX -= (double)this.getColumnWidth(0);
                scrollBarX -= this.getColumnWidth(0);
            }
            boolean needsUpdatedCells = false;
            int scrollBarHeight = this.height;
            float yRatio = (float)(mouseY - (double)scrollBarY) / (float)scrollBarHeight;
            int newYOffset = (int)(yRatio * (float)this.totalRows);
            if (newYOffset != this.rowOffset) {
                this.rowOffset = Math.min(newYOffset, this.totalRows - this.visibleRows);
                needsUpdatedCells = true;
            }
            if (this.rowOffset < 0) {
                this.rowOffset = 0;
            }
            if ((newXOffset = (int)((xRatio = (float)(mouseX - (double)scrollBarX) / (float)(scrollBarWidth = this.width)) * (float)this.totalColumns)) != this.colOffset) {
                this.colOffset = Math.min(newXOffset, this.totalColumns - this.visibleColumns);
                needsUpdatedCells = true;
            }
            if (this.colOffset < 0) {
                this.colOffset = 0;
            }
            if (needsUpdatedCells) {
                this.repositionCells();
            }
            return WidgetEventResult.HANDLED;
        });
    }

    private boolean needsVerticalScrollbar() {
        return this.visibleRows < this.totalRows;
    }

    private boolean needsHorizontalScrollbar() {
        return this.visibleColumns < this.totalColumns;
    }

    public WidgetTable setCellPadding(int cellPadding) {
        this.cellPadding = cellPadding;
        return this;
    }

    public CellData add(int column, int row, Widget widget) {
        return this.add(column, row, new CellData(widget));
    }

    public CellData add(int column, int row, CellData cell) {
        this.totalColumns = Math.max(this.totalColumns, column + 1);
        this.totalRows = Math.max(this.totalRows, row + 1);
        this.table.put((Object)row, (Object)column, (Object)cell);
        this.add(cell.widget());
        return cell;
    }

    public int getCellHeight(int column, int row) {
        if (!this.table.contains((Object)row, (Object)column)) {
            return 0;
        }
        Widget widget = ((CellData)this.table.get((Object)row, (Object)column)).widget();
        return widget.height;
    }

    public int getCellWidth(int column, int row) {
        if (!this.table.contains((Object)row, (Object)column)) {
            return 0;
        }
        Widget widget = ((CellData)this.table.get((Object)row, (Object)column)).widget();
        return widget.width;
    }

    public int getColumnWidth(int column) {
        int maxWidth = 0;
        for (CellData cell : ((Map)this.table.columnMap().get(column)).values()) {
            Widget cellWidget = cell.widget();
            maxWidth = Math.max(maxWidth, cellWidget.width);
        }
        return maxWidth;
    }

    public int getRowHeight(int row) {
        int maxHeight = 0;
        for (CellData cell : ((Map)this.table.rowMap().get(row)).values()) {
            Widget cellWidget = cell.widget();
            maxHeight = Math.max(maxHeight, cellWidget.height);
        }
        return maxHeight;
    }

    public int getColumnCount() {
        return this.table.columnMap().size();
    }

    public int getRowCount() {
        return this.table.rowMap().size();
    }

    @Override
    public void draw(GuiGraphics guiGraphics, Screen screen) {
        int scrollColor;
        if (this.needsVerticalScrollbar()) {
            int skipY = this.alwaysShowFirstRow ? this.getRowHeight(0) : 0;
            int scrollBarX = this.width - this.scrollBarDimension - 1;
            scrollColor = -10066330;
            int matrixHeight = this.height - skipY;
            if (matrixHeight < 0) {
                matrixHeight = 0;
            }
            int rows = this.totalRows - (this.alwaysShowFirstRow ? 1 : 0) - this.visibleRows;
            int pxPerRow = (int)Math.floor((float)matrixHeight / (float)rows);
            int topOffset = this.rowOffset * pxPerRow;
            guiGraphics.fill(scrollBarX + 1, skipY + topOffset, scrollBarX + this.scrollBarDimension - 1, skipY + topOffset + pxPerRow, scrollColor);
        }
        if (this.needsHorizontalScrollbar()) {
            int skipX = this.alwaysShowFirstColumn ? this.getColumnWidth(0) : 0;
            int scrollBarY = this.height - this.scrollBarDimension - 1;
            scrollColor = -10066330;
            int matrixWidth = this.width - skipX;
            if (matrixWidth < 0) {
                matrixWidth = 0;
            }
            int columns = this.totalColumns - (this.alwaysShowFirstColumn ? 1 : 0);
            int pxPerColumn = (int)Math.ceil((float)matrixWidth / (float)columns);
            int leftOffset = this.colOffset * pxPerColumn;
            guiGraphics.fill(skipX + leftOffset, scrollBarY + 1, skipX + leftOffset + pxPerColumn, scrollBarY + this.scrollBarDimension - 1, scrollColor);
        }
        super.draw(guiGraphics, screen);
    }

    public void repositionCells() {
        this.visibleWidth = 0;
        this.visibleRows = 0;
        this.visibleColumns = 0;
        boolean exceededWidth = false;
        int xOffset = 0;
        for (Map.Entry columnData : this.table.columnMap().entrySet()) {
            int column = (Integer)columnData.getKey();
            int columnWidth = this.getColumnWidth(column);
            if (this.visibleWidth + this.cellPadding + columnWidth + this.scrollBarDimension > this.width) {
                exceededWidth = true;
            }
            boolean columnForcedVisible = this.alwaysShowFirstColumn && column == 0;
            boolean exceededHeight = false;
            int localVisibleHeight = 0;
            int yOffset = 0;
            for (Map.Entry cellEntry : ((Map)columnData.getValue()).entrySet()) {
                boolean rowForcedVisible;
                int row = (Integer)cellEntry.getKey();
                CellData cell = (CellData)cellEntry.getValue();
                Widget cellWidget = cell.widget();
                boolean bl = rowForcedVisible = this.alwaysShowFirstRow && row == 0;
                if (!columnForcedVisible && (column < this.colOffset || exceededWidth)) {
                    cellWidget.setVisible(false);
                    continue;
                }
                if (!rowForcedVisible && row < this.rowOffset) {
                    cellWidget.setVisible(false);
                    continue;
                }
                int rowHeight = this.getRowHeight(row);
                if (localVisibleHeight + this.cellPadding + rowHeight + this.scrollBarDimension > this.height) {
                    exceededHeight = true;
                }
                if (exceededHeight) {
                    cellWidget.setVisible(false);
                    continue;
                }
                this.visibleRows = Math.max(this.visibleRows, 1 + row - this.rowOffset);
                this.visibleColumns = Math.max(this.visibleColumns, 1 + column - this.colOffset);
                cellWidget.setVisible(true);
                this.visibleHeight = Math.max(this.visibleHeight, localVisibleHeight += rowHeight + this.cellPadding);
                Vec3i alignmentOffset = cell.contentAlignment().getChildPosition(columnWidth, rowHeight, cellWidget);
                cellWidget.setX(xOffset + alignmentOffset.getX());
                cellWidget.setY(yOffset + alignmentOffset.getY());
                yOffset += rowHeight + this.cellPadding;
            }
            if (!columnForcedVisible && (column < this.colOffset || exceededWidth)) continue;
            this.visibleWidth += columnWidth + this.cellPadding;
            xOffset += columnWidth + this.cellPadding;
        }
    }

    @Override
    public void renderExtraDebugInfo(GuiGraphics pGuiGraphics, Screen screen) {
        String visibleWidth = "Visible Width: " + this.visibleWidth;
        String visibleHeight = "Visible Height: " + this.visibleHeight;
        String visibleColumns = "Visible Columns: " + this.visibleColumns;
        String visibleRows = "Visible Rows: " + this.visibleRows;
        String colOffset = "Col Offset: " + this.colOffset;
        String rowOffset = "Row Offset: " + this.rowOffset;
        pGuiGraphics.drawString(screen.getMinecraft().font, visibleWidth, 0, 30, 0xFF8000);
        pGuiGraphics.drawString(screen.getMinecraft().font, visibleHeight, 0, 40, 0xFF8000);
        pGuiGraphics.drawString(screen.getMinecraft().font, visibleColumns, 0, 50, 0xFF8000);
        pGuiGraphics.drawString(screen.getMinecraft().font, visibleRows, 0, 60, 0xFF8000);
        pGuiGraphics.drawString(screen.getMinecraft().font, colOffset, 0, 70, 0xFF8000);
        pGuiGraphics.drawString(screen.getMinecraft().font, rowOffset, 0, 80, 0xFF8000);
    }

    public void scrollToTop() {
        this.rowOffset = 0;
    }

    public void scrollUp() {
        this.scrollUp(1);
    }

    public void scrollUp(int lines) {
        this.rowOffset = Math.max(0, this.rowOffset - lines);
        this.repositionCells();
    }

    public void scrollDown() {
        this.scrollDown(1);
    }

    public void scrollDown(int lines) {
        this.rowOffset += lines;
        if (this.rowOffset > this.totalRows - this.visibleRows) {
            this.rowOffset = this.totalRows - this.visibleRows;
        }
        this.repositionCells();
    }

    public void scrollToBottom() {
        this.rowOffset = Math.max(0, this.totalRows - this.visibleRows);
    }

    public void scrollToLeftSide() {
        this.colOffset = 0;
    }

    public void scrollToRightSide() {
        this.colOffset = Math.max(0, this.totalColumns - this.visibleColumns);
    }

    public void scrollLeft() {
        this.scrollLeft(1);
    }

    public void scrollLeft(int lines) {
        this.colOffset = Math.max(0, this.colOffset - lines);
        this.repositionCells();
    }

    public void scrollRight() {
        this.scrollRight(1);
    }

    public void scrollRight(int lines) {
        this.colOffset = Math.min(this.colOffset + lines, this.totalColumns - this.visibleColumns);
        this.repositionCells();
    }
}

