/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.PatternConverter;
import com.davenonymous.patternconverter.lib.gui.GUIHelper;
import com.davenonymous.patternconverter.lib.gui.event.MouseDraggedEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseScrollEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class WidgetPanningPanel
extends WidgetPanel {
    public float panX = 0.0f;
    public float panY = 0.0f;
    public float zoomFactor = 1.0f;
    int minX = Integer.MAX_VALUE;
    int minY = Integer.MAX_VALUE;
    int maxX = Integer.MIN_VALUE;
    int maxY = Integer.MIN_VALUE;
    int canvasWidth = 0;
    int canvasHeight = 0;
    Map<Widget, Vector2f> floatPositions = new HashMap<Widget, Vector2f>();

    public WidgetPanningPanel() {
        this.renderDebugOutlines = true;
        this.addListener(MouseDraggedEvent.class, (event, widget) -> {
            if (this.getGUI().isDragging()) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            this.panX += (float)event.dragX();
            this.panY += (float)event.dragY();
            PatternConverter.LOGGER.debug("Panning changed to x={}, y={}", (Object)Float.valueOf(this.panX), (Object)Float.valueOf(this.panY));
            this.repositionWidgets(this.panX, this.panY);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseScrollEvent.class, (event, widget) -> {
            this.zoomFactor += event.rawScrollValue < 0.0 ? -0.1f : 0.1f;
            if (this.zoomFactor < 0.1f) {
                this.zoomFactor = 0.1f;
            }
            if (this.zoomFactor > 4.0f) {
                this.zoomFactor = 4.0f;
            }
            return WidgetEventResult.HANDLED;
        });
    }

    @Override
    public Widget getHoveredWidget(int mouseX, int mouseY) {
        int scaledMouseX = Math.round((float)this.getMouseX() / this.zoomFactor) + this.x;
        int scaledMouseY = Math.round((float)this.getMouseY() / this.zoomFactor) + this.y;
        return super.getHoveredWidget(scaledMouseX, scaledMouseY);
    }

    private void repositionWidgets(float dx, float dy) {
        this.resetCanvasSize();
        for (Widget child : this.children) {
            Vector2f position = new Vector2f((Vector2fc)this.floatPositions.computeIfAbsent(child, k -> new Vector2f())).add(dx, dy);
            child.x = (int)Math.floor(position.x);
            child.y = (int)Math.floor(position.y);
            this.adjustCanvasToWidget(child);
        }
    }

    @Override
    public void add(Widget widget) {
        super.add(widget);
        this.adjustCanvasToWidget(widget);
        this.floatPositions.put(widget, new Vector2f((float)widget.x, (float)widget.y));
        widget.addListener(WidgetSizeChangeEvent.class, (event, w) -> {
            if (w.x < this.minX || w.y < this.minY || w.x + w.width > this.maxX || w.y + w.height > this.maxY) {
                this.adjustCanvasToWidget(w);
            }
            this.floatPositions.put(w, new Vector2f((float)w.x, (float)w.y));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    private void resetCanvasSize() {
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.canvasWidth = 0;
        this.canvasHeight = 0;
    }

    private void adjustCanvasToWidget(Widget widget) {
        if (widget.x < this.minX) {
            this.minX = widget.x;
        }
        if (widget.y < this.minY) {
            this.minY = widget.y;
        }
        if (widget.x + widget.width > this.maxX) {
            this.maxX = widget.x + widget.width;
        }
        if (widget.y + widget.height > this.maxY) {
            this.maxY = widget.y + widget.height;
        }
        this.canvasWidth = this.maxX - this.minX;
        this.canvasHeight = this.maxY - this.minY;
    }

    public void centerOnCanvas() {
        this.panX = (float)(this.canvasWidth - this.width) / -2.0f;
        this.panY = (float)(this.canvasHeight - this.height) / -2.0f;
        this.repositionWidgets(this.panX, this.panY);
    }

    @Override
    public void clear() {
        super.clear();
        this.resetCanvasSize();
    }

    @Override
    public void remove(Widget widget) {
        super.remove(widget);
        if (widget.x == this.minX || widget.y == this.minY || widget.x + widget.width == this.maxX || widget.y + widget.height == this.maxY) {
            this.resetCanvasSize();
            this.children.forEach(this::adjustCanvasToWidget);
        }
    }

    @Override
    public void renderExtraDebugInfo(GuiGraphics pGuiGraphics, Screen screen) {
        String visibleWidth = "Canvas Width: " + this.canvasWidth;
        String visibleHeight = "Canvas Height: " + this.canvasHeight;
        String panPosition = "Pan: x=" + this.panX + ", y=" + this.panY;
        String mousePosition = "Mouse: x=" + this.getMouseX() + ", y=" + this.getMouseY();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(-this.panX, -this.panY, 0.0f);
        pGuiGraphics.drawString(screen.getMinecraft().font, visibleWidth, 0, 30, 0xFF8000);
        pGuiGraphics.drawString(screen.getMinecraft().font, visibleHeight, 0, 40, 0xFF8000);
        pGuiGraphics.drawString(screen.getMinecraft().font, panPosition, 0, 50, 0xFF8000);
        pGuiGraphics.drawString(screen.getMinecraft().font, mousePosition, 0, 60, 0xFF8000);
        pGuiGraphics.pose().popPose();
    }

    @Override
    public void draw(GuiGraphics guiGraphics, Screen screen) {
        guiGraphics.enableScissor(this.x, this.y, this.x + this.width, this.y + this.height);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, -5.0f);
        GUIHelper.drawColoredCanvas(guiGraphics, this.width, this.height, -14540254);
        guiGraphics.renderOutline(this.minX, this.minY, this.canvasWidth, this.canvasHeight, -16777216 + (this.getClass().getSimpleName().hashCode() & 0xFFFFFF));
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(this.zoomFactor, this.zoomFactor, 1.0f);
        super.draw(guiGraphics, screen);
        guiGraphics.pose().popPose();
        guiGraphics.disableScissor();
    }
}

