/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.GUI;
import com.davenonymous.patternconverter.lib.gui.ISelectable;
import com.davenonymous.patternconverter.lib.gui.event.ListSelectionEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseClickEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseDraggedEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseReleasedEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseScrollEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetTextBox;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.phys.Vec2;

public class WidgetList
extends WidgetPanel {
    public int padding = 2;
    public int scrollLines = 1;
    private int lineOffset = 0;
    private int lastVisibleLine = 0;
    private int visibleWidgets = 0;
    protected int selected = -1;
    boolean showSelection = true;
    boolean drawBackground = true;
    boolean autoSelectFirstEntry = false;
    int totalHeight = 0;
    Vec2 dragStart = new Vec2(0.0f, 0.0f);

    public WidgetList() {
        this.addListener(MouseReleasedEvent.class, (event, widget) -> {
            this.getGUI().setDragging(false);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(WidgetSizeChangeEvent.class, (event, widget) -> {
            if (event.changedWidget() == widget) {
                this.width = event.newWidth();
                this.height = event.newHeight();
                this.updateWidgets();
                return WidgetEventResult.HANDLED;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseScrollEvent.class, (event, widget) -> {
            if (!this.areAllParentsVisible()) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            if (widget.isPosInside(event.mouseX, event.mouseY)) {
                int scrollValue = Math.abs((int)Math.ceil(event.rawScrollValue));
                if (event.up) {
                    this.scrollUp(scrollValue);
                } else {
                    this.scrollDown(scrollValue);
                }
                return WidgetEventResult.HANDLED;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseDraggedEvent.class, (event, widget) -> {
            boolean drawScrollbar;
            if (!this.getGUI().isDragging()) {
                this.getGUI().setDragging(true);
                this.dragStart = new Vec2((float)event.mouseX(), (float)event.mouseY());
            }
            boolean bl = drawScrollbar = this.visibleWidgets < this.getTotalLines();
            if (!drawScrollbar) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            int scrollbarWidth = 8;
            int scrollBarX = this.getActualX() + this.width - scrollbarWidth + 1;
            if (this.dragStart.x < (float)scrollBarX || this.dragStart.x > (float)(scrollBarX + scrollbarWidth)) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            if (!this.isPosInside(event.mouseX(), event.mouseY())) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            int scrollBarY = this.getActualY();
            int scrollBarHeight = this.height;
            float ratio = (float)(event.mouseY() - (double)scrollBarY) / (float)scrollBarHeight;
            int newOffset = (int)(ratio * (float)this.getTotalLines());
            if (newOffset != this.lineOffset) {
                this.lineOffset = Math.min(newOffset, this.getTotalLines() - this.visibleWidgets);
                this.updateWidgets();
            }
            return WidgetEventResult.HANDLED;
        });
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            int scrollBarHeight;
            boolean drawScrollbar;
            boolean bl = drawScrollbar = this.visibleWidgets < this.getTotalLines();
            if (!drawScrollbar) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            int scrollbarWidth = 8;
            int scrollBarX = this.getActualX() + this.width - scrollbarWidth + 1;
            if (event.x < (double)scrollBarX || event.x > (double)(scrollBarX + scrollbarWidth)) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            int scrollBarY = this.getActualY();
            float ratio = (float)(event.y - (double)scrollBarY) / (float)(scrollBarHeight = this.height);
            int newOffset = (int)(ratio * (float)this.getTotalLines());
            if (newOffset != this.lineOffset) {
                this.lineOffset = Math.min(newOffset, this.getTotalLines() - this.visibleWidgets);
                this.updateWidgets();
            }
            return WidgetEventResult.HANDLED;
        });
    }

    @Override
    public void clear() {
        super.clear();
        this.selected = -1;
        this.fireEvent(new ListSelectionEvent(this.selected, (Widget)((Object)this.getSelectedWidget())));
    }

    public void scrollToTop() {
        this.lineOffset = 0;
    }

    public void scrollUp() {
        this.scrollUp(1);
    }

    public void scrollUp(int lines) {
        this.lineOffset = Math.max(0, this.lineOffset - lines);
        this.updateWidgets();
    }

    public void scrollDown() {
        this.scrollDown(1);
    }

    public void scrollDown(int lines) {
        this.lineOffset = Math.min(this.lineOffset + lines, this.getTotalLines() - this.visibleWidgets);
        this.updateWidgets();
    }

    public ISelectable getSelectedWidget() {
        if (this.selected == -1 || this.children == null || this.selected >= this.children.size()) {
            return null;
        }
        return (ISelectable)this.children.get(this.selected);
    }

    public void deselect() {
        if (this.selected == -1) {
            return;
        }
        this.getSelectedWidget().setSelected(false);
        this.selected = -1;
        this.fireEvent(new ListSelectionEvent(this.selected, (Widget)((Object)this.getSelectedWidget())));
    }

    public void select(int index) {
        if (index == -1) {
            this.deselect();
            return;
        }
        if (this.selected != -1) {
            this.getSelectedWidget().setSelected(false);
        }
        this.selected = index;
        if (this.getSelectedWidget() != null) {
            this.getSelectedWidget().setSelected(true);
        }
        this.fireEvent(new ListSelectionEvent(this.selected, (Widget)((Object)this.getSelectedWidget())));
    }

    public int getTotalHeight() {
        return Math.max(0, this.totalHeight - this.padding);
    }

    public int getTotalLines() {
        return this.children.size();
    }

    public int getLineHeight(int line) {
        if (line >= this.children.size()) {
            return 0;
        }
        return ((Widget)this.children.get((int)line)).height;
    }

    public boolean shouldDrawBackground() {
        return this.drawBackground;
    }

    public WidgetList setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
        return this;
    }

    public boolean isShowSelection() {
        return this.showSelection;
    }

    public WidgetList setShowSelection(boolean showSelection) {
        this.showSelection = showSelection;
        return this;
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        int backgroundColor = -13421773;
        int borderColor = -16777216;
        int selectedBackgroundColor = -14527198;
        boolean drawScrollbar = this.visibleWidgets < this.getTotalLines();
        int scrollbarWidth = drawScrollbar ? 8 : 0;
        int listWidth = this.width;
        if (this.shouldDrawBackground()) {
            pGuiGraphics.fill(0, 0, listWidth, this.height, borderColor);
            pGuiGraphics.fill(1, 1, listWidth - 1, this.height - 1, backgroundColor);
        }
        if (this.isShowSelection() && this.selected >= this.lineOffset && this.selected <= this.lastVisibleLine) {
            int yOffset = this.padding;
            for (int line = this.lineOffset; line < this.selected; ++line) {
                Widget widget = (Widget)this.children.get(line);
                yOffset += widget.height;
            }
            Widget selectedWidget = (Widget)this.children.get(this.selected);
            pGuiGraphics.fill(1, yOffset, listWidth - 2 - scrollbarWidth, yOffset + 1 + selectedWidget.height - 1, selectedBackgroundColor);
        }
        if (drawScrollbar) {
            int maxPaddleHeight;
            int scrollBarX = listWidth - scrollbarWidth - 1;
            int linesBefore = this.lineOffset;
            int linesAfter = this.getTotalLines() - this.lastVisibleLine - 1;
            int scrollColor = -10066330;
            float ratioBefore = (float)linesBefore / (float)this.getTotalLines();
            float ratioSize = (float)this.visibleWidgets / (float)this.getTotalLines();
            int topOffset = (int)((float)this.height * ratioBefore);
            int paddleHeight = (int)((float)this.height * ratioSize);
            if (topOffset < 2) {
                topOffset = 2;
            }
            if ((maxPaddleHeight = topOffset + paddleHeight) > this.height - 2) {
                maxPaddleHeight = this.height - 2;
            }
            pGuiGraphics.fill(scrollBarX + 1, topOffset, scrollBarX + scrollbarWidth - 1, maxPaddleHeight, scrollColor);
        }
        super.draw(pGuiGraphics, screen);
    }

    public <T extends Widget> void addListEntry(T widget) {
        if (((Widget)widget).height <= 0) {
            GUI.LOGGER.warn("Height-less widget [{}] added to list. This will cause problems.", widget);
        }
        if (((Widget)widget).height > this.height) {
            GUI.LOGGER.warn("List has an entry [{}]={}px larger than the list={}px itself. This will cause problems.", new Object[]{widget, ((Widget)widget).height, this.height});
        }
        this.totalHeight += ((Widget)widget).height + this.padding;
        ((Widget)widget).addListener(MouseClickEvent.class, (event, clickedWidget) -> {
            if (this.selected == this.children.indexOf(widget)) {
                this.selected = -1;
                widget.setSelected(false);
            } else {
                Widget oldSelection;
                if (this.selected != -1 && this.selected < this.children.size() && (oldSelection = (Widget)this.children.get(this.selected)) instanceof ISelectable) {
                    ((ISelectable)((Object)oldSelection)).setSelected(false);
                }
                this.selected = this.children.indexOf(widget);
                widget.setSelected(true);
            }
            this.fireEvent(new ListSelectionEvent(this.selected, (Widget)((Object)this.getSelectedWidget())));
            return WidgetEventResult.HANDLED;
        });
        super.add((Widget)widget);
        this.updateWidgets();
    }

    @Override
    public void remove(Widget widget) {
        super.remove(widget);
        this.updateWidgets();
    }

    public void updateWidgets() {
        int visibleHeight = this.padding;
        boolean exceededListHeight = false;
        this.visibleWidgets = 0;
        for (int line = 0; line < this.children.size(); ++line) {
            Widget widget = (Widget)this.children.get(line);
            if (widget instanceof WidgetTextBox) {
                WidgetTextBox tb = (WidgetTextBox)widget;
                tb.autoWidth();
                if (tb.width > this.width - 11 - this.padding * 2) {
                    tb.setWidth(this.width - 11 - this.padding * 2);
                }
            } else {
                widget.setWidth(this.width - 11 - this.padding * 2);
            }
            if (line < this.lineOffset) {
                widget.setVisible(false);
                continue;
            }
            if (visibleHeight + widget.height > this.height - this.padding) {
                exceededListHeight = true;
            }
            if (exceededListHeight) {
                widget.setVisible(false);
                continue;
            }
            if (line == this.selected && widget instanceof ISelectable) {
                ((ISelectable)((Object)widget)).setSelected(true);
            }
            widget.setVisible(true);
            widget.setY(visibleHeight);
            widget.setX(this.padding);
            visibleHeight += widget.height;
            this.lastVisibleLine = line;
            ++this.visibleWidgets;
        }
    }
}

