/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.GUIHelper;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class WidgetLabel
extends Widget {
    private FormattedText text;
    int textColor = 0xFFFFFF;
    protected Style style = Style.EMPTY;

    public WidgetLabel(String text) {
        this.text = FormattedText.of((String)text, (Style)this.style);
        this.setWidth(100);
        this.setHeight(9);
    }

    public WidgetLabel(String text, Function<Style, Style> styleSetter) {
        this(text);
        this.applyStyle(styleSetter);
    }

    public int getLabelWidth() {
        return Minecraft.getInstance().font.width(this.text);
    }

    public void autoWidth() {
        this.setWidth(this.getLabelWidth() + 2);
    }

    public void autoWidth(int maxWidth) {
        this.setWidth(Math.min(this.getLabelWidth() + 2, maxWidth));
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int textColor() {
        return this.textColor;
    }

    public FormattedText formattedText() {
        return this.text;
    }

    public String text() {
        return this.text.getString();
    }

    public WidgetLabel setText(String text) {
        this.text = FormattedText.of((String)text, (Style)this.style);
        return this;
    }

    public WidgetLabel applyStyle(Function<Style, Style> styleSetter) {
        this.style = styleSetter.apply(this.style);
        this.text = FormattedText.of((String)this.text.getString(), (Style)this.style);
        return this;
    }

    public WidgetLabel clearStyle() {
        this.style = Style.EMPTY;
        this.text = FormattedText.of((String)this.text.getString(), (Style)this.style);
        return this;
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        if (this.text == null) {
            return;
        }
        pGuiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        int scale = WidgetLabel.computeGuiScale(screen.getMinecraft());
        int bottomOffset = (int)(((double)(screen.getMinecraft().getWindow().getHeight() / scale) - (double)(this.getActualY() + this.height)) * (double)scale);
        int heightTmp = this.height * scale - 1;
        if (heightTmp < 0) {
            heightTmp = 0;
        }
        RenderSystem.enableScissor((int)(this.getActualX() * scale - 3), (int)(bottomOffset + 2), (int)(this.width * scale), (int)heightTmp);
        GUIHelper.drawWordWrap(pGuiGraphics, screen.getMinecraft().font, this.text, 0, 0, Integer.MAX_VALUE, this.textColor);
        RenderSystem.disableScissor();
        RenderSystem.disableBlend();
        pGuiGraphics.pose().popPose();
    }
}

