/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.widgets.WidgetWithChoiceValue;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.Size2i;

public class WidgetIconSelect<T>
extends WidgetWithChoiceValue<T> {
    Map<T, IconData> iconMap;
    float textureWidth = 16.0f;
    float textureHeight = 16.0f;
    Size2i offset = new Size2i(0, 0);

    public WidgetIconSelect() {
        this.setHeight(16);
        this.setWidth(16);
        this.iconMap = new HashMap<T, IconData>();
        this.addClickListener();
    }

    public WidgetIconSelect<T> setTextureSize(float width, float height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    public WidgetIconSelect<T> setOffset(Size2i offset) {
        this.offset = offset;
        return this;
    }

    public void mapChoiceToSprite(T choice, IconData sprite) {
        this.iconMap.put(choice, sprite);
    }

    public void addChoiceWithSprite(T choice, IconData sprite) {
        this.addChoice(choice);
        this.mapChoiceToSprite(choice, sprite);
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        IconData sprite = this.iconMap.get(this.getValue());
        if (sprite == null) {
            return;
        }
        if (this.visible && this.areAllParentsVisible()) {
            RenderSystem.enableBlend();
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().scale(this.scale, this.scale, 1.0f);
            pGuiGraphics.blitInscribed(sprite.icon(), this.offset.width, this.offset.height, this.width, this.height, (int)this.textureWidth, (int)this.textureHeight, true, true);
            pGuiGraphics.pose().popPose();
        }
    }

    public record IconData(ResourceLocation icon, int width, int height) {
    }
}

