/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.event.ValueChangedEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetCheckbox;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanelWithValue;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetTextBox;
import net.minecraft.ChatFormatting;

public class WidgetCheckboxWithLabel
extends WidgetPanelWithValue<Boolean> {
    private WidgetCheckbox checkbox = new WidgetCheckbox();
    private WidgetTextBox label;

    public WidgetCheckboxWithLabel(String label) {
        super(false);
        this.setHeight(this.checkbox.height);
        this.add(this.checkbox);
        this.label = new WidgetTextBox(label);
        this.label.setPosition(this.checkbox.width + 4, 2);
        this.label.setHeight(this.checkbox.height);
        this.label.setWordWrap(true);
        this.label.autoWidth();
        this.label.setStyle(style -> style.withColor(ChatFormatting.DARK_GRAY));
        this.add(this.label);
        this.addChildListener(ValueChangedEvent.class, this.checkbox);
        this.addListener(WidgetSizeChangeEvent.class, (event, widget) -> {
            this.label.autoWidth();
            if (this.label.width > this.width - this.checkbox.width - 4) {
                this.label.setWidth(this.width - this.checkbox.width - 4);
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public WidgetTextBox label() {
        return this.label;
    }

    @Override
    public Boolean getValue() {
        return (Boolean)this.checkbox.getValue();
    }

    @Override
    public void setValue(Boolean value) {
        this.checkbox.setValue(value);
    }
}

