/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.GUI;
import com.davenonymous.patternconverter.lib.gui.event.FocusChangedEvent;
import com.davenonymous.patternconverter.lib.gui.event.IEvent;
import com.davenonymous.patternconverter.lib.gui.event.IWidgetListener;
import com.davenonymous.patternconverter.lib.gui.event.KeyReleasedEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseClickEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseEnterEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseExitEvent;
import com.davenonymous.patternconverter.lib.gui.event.VisibilityChangedEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.joml.Vector2f;

public class Widget {
    private static int nextId = 0;
    public int id = nextId++;
    public int x;
    public int y;
    public int width;
    public int height;
    public float scale = 1.0f;
    public float zLevel = 0.0f;
    ResourceLocation backgroundSprite = null;
    boolean enabled = true;
    boolean focused = false;
    boolean selected = false;
    boolean visible = true;
    boolean hovered = false;
    boolean shouldShowTooltip = true;
    boolean renderDebugOutlines = false;
    Widget parent;
    int actualTooltipWidth = 0;
    List<Either<Component, TooltipComponent>> tooltipElements = new ArrayList<Either<Component, TooltipComponent>>();
    Map<Class<? extends IEvent>, List<IWidgetListener>> eventListeners = new HashMap<Class<? extends IEvent>, List<IWidgetListener>>();
    List<IWidgetListener> anyEventListener = new ArrayList<IWidgetListener>();

    public Widget() {
        this.addListener(KeyReleasedEvent.class, (event, widget) -> {
            int keyCode = event.keyCode;
            if (keyCode == 292) {
                this.renderDebugOutlines = !this.renderDebugOutlines;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            widget.getRootWidget().fireEvent(new FocusChangedEvent());
            if (widget.focusable()) {
                widget.focused = true;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(FocusChangedEvent.class, (event, widget) -> {
            widget.focused = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            widget.hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            widget.hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public Widget setActualTooltipWidth(int actualTooltipWidth) {
        this.actualTooltipWidth = actualTooltipWidth;
        return this;
    }

    public int getActualTooltipWidth() {
        return this.actualTooltipWidth;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Widget)) {
            return false;
        }
        Widget widget = (Widget)o;
        return this.id == widget.id;
    }

    public int hashCode() {
        return this.id;
    }

    public Widget setBackgroundSprite(ResourceLocation backgroundSprite) {
        this.backgroundSprite = backgroundSprite;
        return this;
    }

    public Widget setPosition(Vector2f position) {
        this.setX((int)position.x);
        this.setY((int)position.y);
        return this;
    }

    public Widget setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    public Widget setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        return this;
    }

    public Widget setDimensions(int x, int y, int width, int height) {
        this.setSize(width, height);
        this.setPosition(x, y);
        return this;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public boolean hasToolTip() {
        return this.tooltipElements != null && !this.tooltipElements.isEmpty();
    }

    public List<Either<Component, TooltipComponent>> getTooltip() {
        if (this.tooltipElements == null) {
            return Collections.emptyList();
        }
        return this.tooltipElements;
    }

    public List<Either<FormattedText, TooltipComponent>> getTooltipFormatted() {
        if (this.tooltipElements == null) {
            return Collections.emptyList();
        }
        ArrayList<Either<FormattedText, TooltipComponent>> result = new ArrayList<Either<FormattedText, TooltipComponent>>();
        for (Either<Component, TooltipComponent> element : this.tooltipElements) {
            if (element.left().isPresent()) {
                result.add((Either<FormattedText, TooltipComponent>)Either.left((Object)FormattedText.of((String)((Component)element.left().get()).getString(), (Style)((Component)element.left().get()).getStyle())));
                continue;
            }
            result.add((Either<FormattedText, TooltipComponent>)Either.right((Object)((TooltipComponent)element.right().get())));
        }
        return result;
    }

    public Widget setTooltipLinesEither(List<Either<Component, TooltipComponent>> tooltipElements) {
        this.tooltipElements = tooltipElements;
        return this;
    }

    public Widget setTooltipLines(List<Component> tooltipElements) {
        this.tooltipElements = new ArrayList<Either<Component, TooltipComponent>>();
        for (Component line : tooltipElements) {
            this.tooltipElements.add((Either<Component, TooltipComponent>)Either.left((Object)line));
        }
        return this;
    }

    public Widget setTooltipLines(Component ... tooltipElements) {
        this.tooltipElements = new ArrayList<Either<Component, TooltipComponent>>();
        for (Component line : tooltipElements) {
            this.tooltipElements.add((Either<Component, TooltipComponent>)Either.left((Object)line));
        }
        return this;
    }

    public Widget setTooltipElements(List<? extends TooltipComponent> tooltipElements) {
        this.tooltipElements = new ArrayList<Either<Component, TooltipComponent>>();
        for (TooltipComponent tooltipComponent : tooltipElements) {
            this.tooltipElements.add((Either<Component, TooltipComponent>)Either.right((Object)tooltipComponent));
        }
        return this;
    }

    public Widget setTooltipElements(TooltipComponent ... tooltipElements) {
        this.tooltipElements = new ArrayList<Either<Component, TooltipComponent>>();
        for (TooltipComponent line : tooltipElements) {
            this.tooltipElements.add((Either<Component, TooltipComponent>)Either.right((Object)line));
        }
        return this;
    }

    public Widget setTooltipEither(Either<Component, TooltipComponent> ... tooltipElements) {
        this.tooltipElements = new ArrayList<Either<Component, TooltipComponent>>();
        Collections.addAll(this.tooltipElements, tooltipElements);
        return this;
    }

    public Widget addTooltipLine(Component ... tooltipElements) {
        for (Component line : tooltipElements) {
            this.tooltipElements.add((Either<Component, TooltipComponent>)Either.left((Object)line));
        }
        return this;
    }

    public Widget addTooltipLine(List<Component> tooltipElements) {
        for (Component line : tooltipElements) {
            this.tooltipElements.add((Either<Component, TooltipComponent>)Either.left((Object)line));
        }
        return this;
    }

    public Widget addTooltipElement(TooltipComponent ... tooltipElements) {
        for (TooltipComponent line : tooltipElements) {
            this.tooltipElements.add((Either<Component, TooltipComponent>)Either.right((Object)line));
        }
        return this;
    }

    public Widget addTooltipElement(List<TooltipComponent> tooltipElements) {
        for (TooltipComponent line : tooltipElements) {
            this.tooltipElements.add((Either<Component, TooltipComponent>)Either.right((Object)line));
        }
        return this;
    }

    public Widget addTooltipEither(Either<Component, TooltipComponent> ... tooltipElements) {
        Collections.addAll(this.tooltipElements, tooltipElements);
        return this;
    }

    public Widget addTooltipEither(List<Either<Component, TooltipComponent>> elements) {
        this.tooltipElements.addAll(elements);
        return this;
    }

    public Widget insertTooltipLine(int index, Component line) {
        this.tooltipElements.add(index, (Either<Component, TooltipComponent>)Either.left((Object)line));
        return this;
    }

    public Widget insertTooltipElement(int index, TooltipComponent line) {
        this.tooltipElements.add(index, (Either<Component, TooltipComponent>)Either.right((Object)line));
        return this;
    }

    public Widget insertTooltipEither(int index, Either<Component, TooltipComponent> line) {
        this.tooltipElements.add(index, line);
        return this;
    }

    public boolean areAllParentsVisible() {
        return this.isVisible() && (this.parent == null || this.parent.areAllParentsVisible());
    }

    public boolean focusable() {
        return true;
    }

    public static int computeGuiScale(Minecraft mc) {
        int scaleFactor = 1;
        int k = (Integer)mc.options.guiScale().get();
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.getWindow().getWidth() / (scaleFactor + 1) >= 320 && mc.getWindow().getHeight() / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[?]";
    }

    public boolean isPosInside(double x, double y) {
        boolean isInsideX = (double)this.getActualX() <= x && x < (double)(this.getActualX() + this.width);
        boolean isInsideY = (double)this.getActualY() <= y && y < (double)(this.getActualY() + this.height);
        return isInsideX && isInsideY;
    }

    public int getActualX() {
        int result = this.x;
        Widget parent = this.parent;
        while (parent != null) {
            result += parent.x;
            parent = parent.parent;
        }
        return result;
    }

    public int getActualY() {
        int result = this.y;
        Widget parent = this.parent;
        while (parent != null) {
            result += parent.y;
            parent = parent.parent;
        }
        return result;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        int oldWidth = this.width;
        this.width = width;
        this.fireEvent(new WidgetSizeChangeEvent(oldWidth, this.height, width, this.height, this));
    }

    public void setHeight(int height) {
        int oldHeight = this.height;
        this.height = height;
        this.fireEvent(new WidgetSizeChangeEvent(this.width, oldHeight, this.width, height, this));
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.fireEvent(new VisibilityChangedEvent(oldVisible, visible));
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDisabled() {
        this.enabled = false;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setShouldShowTooltip(boolean shouldShowTooltip) {
        this.shouldShowTooltip = shouldShowTooltip;
    }

    public void setParent(Widget parent) {
        this.parent = parent;
    }

    public Widget getParent() {
        return this.parent;
    }

    public <T extends Widget> T getParentByType(Class<T> type) {
        Widget current = this.parent;
        while (current != null) {
            if (type.isInstance(current)) {
                return (T)current;
            }
            current = current.parent;
        }
        return null;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public Widget getRootWidget() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootWidget();
    }

    public GUI getGUI() {
        Widget root = this.getRootWidget();
        if (root instanceof GUI) {
            return (GUI)root;
        }
        return null;
    }

    public void shiftAndDraw(GuiGraphics pGuiGraphics, Screen screen) {
        this.drawBeforeShift(pGuiGraphics, screen);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.x, (float)this.y, this.zLevel);
        pGuiGraphics.pose().scale(this.scale, this.scale, this.scale);
        if (this.backgroundSprite != null) {
            pGuiGraphics.blitSprite(this.backgroundSprite, 0, 0, this.width, this.height);
        }
        this.draw(pGuiGraphics, screen);
        if (this.renderDebugOutlines) {
            WidgetPanel panel;
            Widget widget;
            pGuiGraphics.renderOutline(-1, -1, this.width + 1, this.height + 1, -16777216 + (this.getClass().getSimpleName().hashCode() & 0xFFFFFF));
            if (this.isHovered() && (!(this instanceof WidgetPanel) || (widget = this) instanceof WidgetPanel && !(panel = (WidgetPanel)widget).children().stream().anyMatch(w -> w.isHovered() && w.isVisible()))) {
                String what = String.format("%s", this.getClass().getSimpleName());
                String pos = String.format("x=%d y=%d", this.x, this.y);
                String size = String.format("w=%d h=%d", this.width, this.height);
                pGuiGraphics.drawString(screen.getMinecraft().font, what, 0, 0, 0xFF8000);
                pGuiGraphics.drawString(screen.getMinecraft().font, pos, 0, 10, 0xFF8000);
                pGuiGraphics.drawString(screen.getMinecraft().font, size, 0, 20, 0xFF8000);
                this.renderExtraDebugInfo(pGuiGraphics, screen);
            }
        }
        pGuiGraphics.pose().popPose();
    }

    public int getMouseX() {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        return Mth.floor((double)(minecraft.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth())) - this.getActualX();
    }

    public int getMouseY() {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        return Mth.floor((double)(minecraft.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight())) - this.getActualY();
    }

    public void renderExtraDebugInfo(GuiGraphics pGuiGraphics, Screen screen) {
    }

    public void drawBeforeShift(GuiGraphics pGuiGraphics, Screen screen) {
    }

    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
    }

    public void removeEventListeners(Class<? extends IEvent> eventClass) {
        this.eventListeners.remove(eventClass);
    }

    public <T extends IEvent> void addListener(Class<T> eventClass, IWidgetListener<? super T> listener) {
        if (!this.eventListeners.containsKey(eventClass)) {
            this.eventListeners.put(eventClass, new ArrayList());
        }
        this.eventListeners.get(eventClass).add(listener);
    }

    public void addAnyListener(IWidgetListener listener) {
        this.anyEventListener.add(listener);
    }

    public <T extends IEvent> void addChildListener(Class<T> eventClass, Widget receiveEventsFromWidget) {
        Widget self = this;
        receiveEventsFromWidget.addListener(eventClass, (event, widget) -> self.fireEvent(event));
    }

    public WidgetEventResult fireEvent(IEvent event) {
        WidgetEventResult immediateResult;
        for (IWidgetListener listener : this.anyEventListener) {
            immediateResult = listener.call(event, this);
            if (immediateResult != WidgetEventResult.HANDLED) continue;
            return WidgetEventResult.HANDLED;
        }
        if (!this.eventListeners.containsKey(event.getClass())) {
            return WidgetEventResult.CONTINUE_PROCESSING;
        }
        for (IWidgetListener listener : this.eventListeners.get(event.getClass())) {
            immediateResult = listener.call(event, this);
            if (immediateResult != WidgetEventResult.HANDLED) continue;
            return WidgetEventResult.HANDLED;
        }
        return WidgetEventResult.CONTINUE_PROCESSING;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean shouldShowTooltip() {
        return this.shouldShowTooltip;
    }
}

