/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.widgets;

import com.davenonymous.patternconverter.lib.gui.event.MouseClickEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseEnterEvent;
import com.davenonymous.patternconverter.lib.gui.event.MouseExitEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.event.WidgetSizeChangeEvent;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractWidgetButton<T extends Widget>
extends WidgetPanel {
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    public boolean hovered = false;
    private T widget;

    protected AbstractWidgetButton(T pWidget) {
        this.setHeight(20);
        this.setWidth(100);
        this.widget = pWidget;
        this.add((Widget)pWidget);
        this.addListener(WidgetSizeChangeEvent.class, (event, widget) -> {
            int xOffset;
            int yOffset = (this.height - ((Widget)this.widget).height) / 2;
            if (yOffset < 0) {
                yOffset = 0;
            }
            if ((xOffset = (this.width - ((Widget)this.widget).width) / 2) < 0) {
                xOffset = 0;
            }
            ((Widget)this.widget).setPosition(xOffset, yOffset);
            return WidgetEventResult.HANDLED;
        });
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            this.hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            this.hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public T widget() {
        return this.widget;
    }

    public AbstractWidgetButton<T> setWidget(T widget) {
        this.widget = widget;
        return this;
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        pGuiGraphics.blitSprite(SPRITES.get(this.enabled, this.isHovered()), 0, 0, this.width, this.height);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(0.0f, 0.0f, 10.0f);
        super.draw(pGuiGraphics, screen);
        pGuiGraphics.pose().popPose();
    }
}

