/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.tooltip;

import com.davenonymous.patternconverter.lib.gui.GUIHelper;
import com.davenonymous.patternconverter.lib.gui.tooltip.SerializableTooltipComponent;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class WrappedStringTooltipComponent
implements SerializableTooltipComponent<WrappedStringTooltipComponent> {
    public static final StreamCodec<FriendlyByteBuf, WrappedStringTooltipComponent> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, WrappedStringTooltipComponent::message, (StreamCodec)ByteBufCodecs.INT, WrappedStringTooltipComponent::color, (StreamCodec)ByteBufCodecs.INT, WrappedStringTooltipComponent::maxWidth, WrappedStringTooltipComponent::new);
    public String message;
    public int color;
    public int maxWidth;

    public WrappedStringTooltipComponent(String message, int color, int maxWidth) {
        this.message = message;
        this.color = color;
        this.maxWidth = maxWidth;
    }

    private static int defaultMaxWidth() {
        return 240;
    }

    public static WrappedStringTooltipComponent white(String message) {
        return WrappedStringTooltipComponent.white(message, WrappedStringTooltipComponent.defaultMaxWidth());
    }

    public static WrappedStringTooltipComponent white(String message, int maxWidth) {
        return new WrappedStringTooltipComponent(message, ChatFormatting.WHITE.getColor(), maxWidth);
    }

    public static WrappedStringTooltipComponent gray(String message) {
        return WrappedStringTooltipComponent.gray(message, WrappedStringTooltipComponent.defaultMaxWidth());
    }

    public static WrappedStringTooltipComponent gray(String message, int maxWidth) {
        return new WrappedStringTooltipComponent(message, ChatFormatting.GRAY.getColor(), maxWidth);
    }

    public static WrappedStringTooltipComponent yellow(String message) {
        return WrappedStringTooltipComponent.yellow(message, WrappedStringTooltipComponent.defaultMaxWidth());
    }

    public static WrappedStringTooltipComponent yellow(String message, int maxWidth) {
        return new WrappedStringTooltipComponent(message, ChatFormatting.YELLOW.getColor(), maxWidth);
    }

    public static WrappedStringTooltipComponent green(String message) {
        return new WrappedStringTooltipComponent(message, -12010692, WrappedStringTooltipComponent.defaultMaxWidth());
    }

    public static WrappedStringTooltipComponent orange(String message) {
        return new WrappedStringTooltipComponent(message, -1658112, WrappedStringTooltipComponent.defaultMaxWidth());
    }

    public static WrappedStringTooltipComponent cyan(String message) {
        return new WrappedStringTooltipComponent(message, -16734530, WrappedStringTooltipComponent.defaultMaxWidth());
    }

    public static WrappedStringTooltipComponent red(String message) {
        return new WrappedStringTooltipComponent(message, ChatFormatting.RED.getColor(), WrappedStringTooltipComponent.defaultMaxWidth());
    }

    public int getHeight() {
        return GUIHelper.wordWrapHeight(Minecraft.getInstance().font, FormattedText.of((String)this.message), this.maxWidth);
    }

    public int getWidth(Font font) {
        return GUIHelper.longestWrappedLine(font, FormattedText.of((String)this.message), this.maxWidth);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        GUIHelper.drawWordWrap(guiGraphics, font, FormattedText.of((String)this.message), x, y, this.maxWidth, this.color);
    }

    @Override
    public StreamCodec<FriendlyByteBuf, WrappedStringTooltipComponent> getCodec() {
        return CODEC;
    }

    public String message() {
        return this.message;
    }

    public int color() {
        return this.color;
    }

    public int maxWidth() {
        return this.maxWidth;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        WrappedStringTooltipComponent that = (WrappedStringTooltipComponent)obj;
        return Objects.equals(this.message, that.message) && this.color == that.color && this.maxWidth == that.maxWidth;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.color, this.maxWidth);
    }

    public String toString() {
        return "WrappedStringTooltipComponent[message=" + this.message + ", color=" + this.color + ", maxWidth=" + this.maxWidth + "]";
    }
}

