/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.tooltip;

import com.davenonymous.patternconverter.lib.gui.tooltip.SerializableTooltipComponent;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class StringTooltipComponent
implements SerializableTooltipComponent<StringTooltipComponent> {
    public static final StreamCodec<FriendlyByteBuf, StringTooltipComponent> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, StringTooltipComponent::message, (StreamCodec)ByteBufCodecs.INT, StringTooltipComponent::color, StringTooltipComponent::new);
    public String message;
    public int color;

    public StringTooltipComponent(String message, int color) {
        this.message = message;
        this.color = color;
    }

    public static final StringTooltipComponent white(String message) {
        return new StringTooltipComponent(message, ChatFormatting.WHITE.getColor());
    }

    public static final StringTooltipComponent gray(String message) {
        return new StringTooltipComponent(message, ChatFormatting.GRAY.getColor());
    }

    public static final StringTooltipComponent chat(String message, ChatFormatting color) {
        return new StringTooltipComponent(message, color.getColor());
    }

    public static StringTooltipComponent green(String message) {
        return new StringTooltipComponent(message, -12010692);
    }

    public static StringTooltipComponent orange(String message) {
        return new StringTooltipComponent(message, -1658112);
    }

    public static StringTooltipComponent cyan(String message) {
        return new StringTooltipComponent(message, -16734530);
    }

    public int getHeight() {
        return 10;
    }

    public int getWidth(Font font) {
        return font.width(this.message);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.drawString(font, this.message, x, y, this.color);
    }

    @Override
    public StreamCodec<FriendlyByteBuf, StringTooltipComponent> getCodec() {
        return CODEC;
    }

    public String message() {
        return this.message;
    }

    public int color() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StringTooltipComponent that = (StringTooltipComponent)obj;
        return Objects.equals(this.message, that.message) && this.color == that.color;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.color);
    }

    public String toString() {
        return "StringTooltipComponent[message=" + this.message + ", color=" + this.color + "]";
    }
}

