/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.tooltip;

import com.davenonymous.patternconverter.PatternConverter;
import com.davenonymous.patternconverter.lib.gui.event.MouseScrollEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class ScrollableTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private ClientTooltipComponent component;
    private int maxHeight;
    private float scrollOffset;
    private Widget scollSource;

    public ScrollableTooltipComponent(ClientTooltipComponent component, int maxHeight, Widget scrollSource) {
        this.component = component;
        this.maxHeight = maxHeight;
        this.scollSource = scrollSource;
        this.scollSource.addListener(MouseScrollEvent.class, (event, widget) -> {
            this.scrollUp((float)event.rawScrollValue);
            return WidgetEventResult.HANDLED;
        });
    }

    public void setScrollOffset(float scrollOffset) {
        this.scrollOffset = scrollOffset;
    }

    public float getScrollOffset() {
        return this.scrollOffset;
    }

    public void scrollUp(float amount) {
        int scale = Widget.computeGuiScale(Minecraft.getInstance());
        this.scrollOffset += amount * (float)scale;
        if (-this.scrollOffset < 0.0f) {
            this.scrollOffset = 0.0f;
        }
        PatternConverter.LOGGER.info("Widget={}, offset={}, compHeight={}, maxHeight={}", new Object[]{this.component.toString(), Float.valueOf(this.scrollOffset), this.component.getHeight(), this.maxHeight});
    }

    public int getHeight() {
        return Math.min(this.maxHeight, this.component.getHeight());
    }

    public int getWidth(Font font) {
        return this.component.getWidth(font);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics pGuiGraphics) {
        int scale = Widget.computeGuiScale(Minecraft.getInstance());
        int bottomOffset = (int)(((double)(Minecraft.getInstance().getWindow().getHeight() / scale) - (double)(y + this.getHeight())) * (double)scale);
        int heightTmp = this.getHeight() * scale - 1;
        if (heightTmp < 0) {
            heightTmp = 0;
        }
        RenderSystem.enableScissor((int)(x * scale - 3), (int)(bottomOffset + 2), (int)(this.getWidth(font) * scale), (int)heightTmp);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(0.0f, this.scrollOffset * 8.0f, 0.0f);
        this.component.renderImage(font, x, y, pGuiGraphics);
        pGuiGraphics.pose().popPose();
        RenderSystem.disableScissor();
    }
}

