/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui.tooltip;

import com.davenonymous.patternconverter.lib.gui.tooltip.SeparatorTooltipComponent;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;

public class LabeledLineSeparatorTooltipComponent
extends SeparatorTooltipComponent {
    int padding = 2;
    int lineWidth = 1;
    int lineColor = -1;
    String label;

    public LabeledLineSeparatorTooltipComponent(Widget owner, String label) {
        super(owner);
        this.label = label;
    }

    public static LabeledLineSeparatorTooltipComponent advancedInfos(Widget owner) {
        return new LabeledLineSeparatorTooltipComponent(owner, I18n.get((String)"patternconverter.message.advanced_tooltips", (Object[])new Object[0]));
    }

    public LabeledLineSeparatorTooltipComponent setColor(int lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    public LabeledLineSeparatorTooltipComponent setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public LabeledLineSeparatorTooltipComponent setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    @Override
    public void renderSeparator(Font font, int maxTooltipWidth, GuiGraphics guiGraphics) {
        int labelWidth = font.width(this.label);
        int labelX = (maxTooltipWidth - labelWidth) / 2;
        int leftLineEnd = labelX - this.padding;
        int rightLineStart = labelX + labelWidth + this.padding;
        Objects.requireNonNull(font);
        int textHeight = 9;
        int lineToTextOffset = Math.floorDiv(textHeight - this.lineWidth, 2) - 1;
        guiGraphics.fill(this.padding, this.padding + lineToTextOffset, leftLineEnd, this.padding + this.lineWidth + lineToTextOffset, this.lineColor);
        guiGraphics.drawString(font, this.label, labelX, this.padding, this.lineColor, false);
        guiGraphics.fill(rightLineStart, this.padding + lineToTextOffset, maxTooltipWidth - this.padding, this.padding + this.lineWidth + lineToTextOffset, this.lineColor);
    }

    @Override
    public int getHeight() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        int textHeight = 9;
        return Math.max(textHeight, this.lineWidth) + 2 * this.padding;
    }

    @Override
    public int getWidth(Font font) {
        int labelWidth = font.width(this.label);
        return labelWidth + 2 * this.padding + 32;
    }
}

