/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui;

import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;

public enum RedstoneMode implements StringRepresentable
{
    IGNORE_POWER(0, "ignore", (Component)Component.translatable((String)"patternconverter.redstone_mode.ignore_power")),
    REQUIRE_POWER(1, "require", (Component)Component.translatable((String)"patternconverter.redstone_mode.require_power")),
    STOP_ON_POWER(2, "stop", (Component)Component.translatable((String)"patternconverter.redstone_mode.stop_on_power"));

    private final int id;
    private final String key;
    private final Component description;
    public static final IntFunction<RedstoneMode> BY_ID;
    public static final StringRepresentable.EnumCodec<RedstoneMode> CODEC;
    public static final StreamCodec<ByteBuf, RedstoneMode> STREAM_CODEC;

    private RedstoneMode(int id, String key, Component description) {
        this.description = description;
        this.id = id;
        this.key = key;
    }

    public boolean resolve(Level level, BlockPos pos) {
        return switch (this.ordinal()) {
            case 0 -> true;
            case 1 -> level.hasNeighborSignal(pos);
            case 2 -> {
                if (!level.hasNeighborSignal(pos)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static RedstoneMode byId(int id) {
        return BY_ID.apply(id);
    }

    public int getId() {
        return this.id;
    }

    public Component getDescription() {
        return this.description;
    }

    public String getSerializedName() {
        return this.key;
    }

    static {
        BY_ID = ByIdMap.continuous(RedstoneMode::getId, (Object[])RedstoneMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODEC = StringRepresentable.fromEnum(RedstoneMode::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, RedstoneMode::getId);
    }
}

