/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.lib.gui;

import com.davenonymous.patternconverter.PatternConverter;
import com.davenonymous.patternconverter.lib.gui.GUIHelper;
import com.davenonymous.patternconverter.lib.gui.WidgetContainer;
import com.davenonymous.patternconverter.lib.gui.WidgetSlot;
import com.davenonymous.patternconverter.lib.gui.widgets.IValueProvider;
import com.davenonymous.patternconverter.lib.gui.widgets.Widget;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetPanel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class GUI
extends WidgetPanel {
    public static ResourceLocation tabIcons = PatternConverter.resource("textures/gui/tabicons.png");
    public static ResourceLocation windowBackground = PatternConverter.resource("textures/gui/window.png");
    public static ResourceLocation defaultButtonTexture = PatternConverter.resource("textures/gui/button_background.png");
    public static final Logger LOGGER = LogUtils.getLogger();
    public boolean hasTabs = false;
    private final Map<ResourceLocation, IValueProvider> valueMap = new HashMap<ResourceLocation, IValueProvider>();
    private WidgetContainer container;
    private boolean isDragging = false;
    private final Set<Integer> pressedKeys = new HashSet<Integer>();
    private static final int SCAN_CODE_CTRL = 29;
    private static final int SCAN_CODE_CTRL_LEFT = 157;
    private static final int SCAN_CODE_CTRL_RIGHT = 197;
    private static final int SCAN_CODE_SHIFT = 42;
    private static final int SCAN_CODE_SHIFT_LEFT = 54;
    private static final int SCAN_CODE_SHIFT_RIGHT = 55;

    public GUI(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void findValueWidgets() {
        this.findValueWidgets(this);
    }

    public void registerValueWidget(ResourceLocation id, IValueProvider widget) {
        this.valueMap.put(id, widget);
    }

    public Object getValue(ResourceLocation id) {
        if (id == null || !this.valueMap.containsKey(id)) {
            return null;
        }
        return this.valueMap.get(id).getValue();
    }

    public void drawGUI(GuiGraphics pGuiGraphics, Screen screen) {
        this.setX((screen.width - this.width) / 2);
        this.setY((screen.height - this.height) / 2);
        this.shiftAndDraw(pGuiGraphics, screen);
    }

    @Override
    public void drawBeforeShift(GuiGraphics pGuiGraphics, Screen screen) {
        super.drawBeforeShift(pGuiGraphics, screen);
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        GUIHelper.drawWindow(pGuiGraphics, this.width, this.height, this.hasTabs);
        super.draw(pGuiGraphics, screen);
    }

    public void drawTooltips(GuiGraphics pGuiGraphics, Screen screen, int mouseX, int mouseY) {
        Widget hoveredWidget = this.getHoveredWidget(mouseX, mouseY);
        if (hoveredWidget == null || hoveredWidget.getTooltip() == null) {
            return;
        }
        if (hoveredWidget.getTooltip().isEmpty()) {
            return;
        }
        if (!hoveredWidget.shouldShowTooltip()) {
            return;
        }
        Font font = screen.getMinecraft().font;
        List<Either<FormattedText, TooltipComponent>> formattedTooltip = hoveredWidget.getTooltipFormatted();
        int maxWidth = Integer.MIN_VALUE;
        for (Either<FormattedText, TooltipComponent> line : formattedTooltip) {
            Object t;
            if (line.left().isPresent()) {
                FormattedText text = (FormattedText)line.left().get();
                maxWidth = Math.max(maxWidth, font.width(text));
                continue;
            }
            if (!line.right().isPresent() || !((t = line.right().get()) instanceof ClientTooltipComponent)) continue;
            ClientTooltipComponent clientTooltipComponent = (ClientTooltipComponent)t;
            maxWidth = Math.max(maxWidth, clientTooltipComponent.getWidth(font));
        }
        hoveredWidget.setActualTooltipWidth(maxWidth);
        pGuiGraphics.renderComponentTooltipFromElements(font, hoveredWidget.getTooltipFormatted(), mouseX, mouseY, ItemStack.EMPTY);
    }

    public void drawSlot(GuiGraphics pGuiGraphics, Screen screen, Slot slot, int guiLeft, int guiTop) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (slot instanceof WidgetSlot && !slot.allowModification((Player)screen.getMinecraft().player)) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
        }
        float offsetX = guiLeft - 1;
        float offsetY = guiTop - 1;
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(offsetX, offsetY, 0.0f);
        int texOffsetY = 84;
        int texOffsetX = 84;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUIHelper.tabIcons);
        pGuiGraphics.blit(GUIHelper.tabIcons, slot.x, slot.y, texOffsetX, texOffsetY, 18, 18);
        pGuiGraphics.pose().popPose();
    }

    public void setContainer(WidgetContainer container) {
        this.container = container;
    }

    public WidgetContainer getContainer() {
        return this.container;
    }

    public void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void keyDown(int scanCode) {
        this.pressedKeys.add(scanCode);
    }

    public void keyUp(int scanCode) {
        this.pressedKeys.remove(scanCode);
    }

    public boolean isKeyPressed(int scanCode) {
        return this.pressedKeys.contains(scanCode);
    }

    public boolean isCtrlDown() {
        return this.isKeyPressed(29) || this.isKeyPressed(157) || this.isKeyPressed(197);
    }

    public boolean isShiftDown() {
        return this.isKeyPressed(42) || this.isKeyPressed(54) || this.isKeyPressed(55);
    }
}

