/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.gui;

import com.davenonymous.patternconverter.lib.gui.Icons;
import com.davenonymous.patternconverter.lib.gui.event.ValueChangedEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetIconSelect;
import net.minecraft.network.chat.Component;

public class WidgetPatternMode
extends WidgetIconSelect<Boolean> {
    public WidgetPatternMode() {
        this(false);
    }

    public WidgetPatternMode(boolean initial) {
        this.setSize(16, 12);
        this.setTextureSize(16.0f, 12.0f);
        this.addChoiceWithSprite(true, new WidgetIconSelect.IconData(Icons.clearPatterns, 16, 12));
        this.addChoiceWithSprite(false, new WidgetIconSelect.IconData(Icons.keepPatterns, 16, 12));
        this.setValue(initial);
        this.updateToolTips();
        this.addListener(ValueChangedEvent.class, (event, widget) -> {
            this.updateToolTips();
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public void updateToolTips() {
        String translationKey = (Boolean)this.getValue() != false ? "patternconverter.pattern_mode.clear_original" : "patternconverter.pattern_mode.keep_original";
        this.setTooltipLines(new Component[]{Component.translatable((String)translationKey)});
    }
}

