/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.datagen;

import com.davenonymous.patternconverter.blocks.ConverterBlock;
import com.davenonymous.patternconverter.mods.ConverterStyle;
import com.davenonymous.patternconverter.setup.ModBlocks;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class DGBlockStates
extends BlockStateProvider {
    private final ExistingFileHelper exFileHelper;

    public DGBlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "patternconverter", exFileHelper);
        this.exFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        this.ownDirectionalBlock((Block)ModBlocks.CONVERTER_BLOCK.get(), blockState -> {
            ConverterStyle style = (ConverterStyle)((Object)((Object)blockState.getValue(ConverterBlock.STYLE)));
            return new ModelFile.ExistingModelFile(style.modelLocation(), this.exFileHelper);
        });
    }

    public void ownDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state));
            builder = dir == Direction.DOWN ? builder.rotationX(90) : (dir == Direction.UP ? builder.rotationX(270) : builder.rotationY(((int)dir.toYRot() + 180) % 360));
            return builder.build();
        });
    }
}

