/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.blocks;

import com.davenonymous.patternconverter.blocks.ConverterBlockEntity;
import com.davenonymous.patternconverter.blocks.ConverterContainer;
import com.davenonymous.patternconverter.gui.WidgetPatternMode;
import com.davenonymous.patternconverter.lib.gui.GUI;
import com.davenonymous.patternconverter.lib.gui.RedstoneMode;
import com.davenonymous.patternconverter.lib.gui.WidgetContainer;
import com.davenonymous.patternconverter.lib.gui.WidgetContainerScreen;
import com.davenonymous.patternconverter.lib.gui.event.GuiDataUpdatedEvent;
import com.davenonymous.patternconverter.lib.gui.event.ValueChangedEvent;
import com.davenonymous.patternconverter.lib.gui.event.WidgetEventResult;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetProgressArrow;
import com.davenonymous.patternconverter.lib.gui.widgets.WidgetRedstoneMode;
import com.davenonymous.patternconverter.networking.SetClearPatterns;
import com.davenonymous.patternconverter.networking.SetRedstoneMode;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConverterScreen
extends WidgetContainerScreen<ConverterContainer> {
    private List<Item> allSoilsSorted;

    public ConverterScreen(ConverterContainer container, Inventory inv, Component name) {
        super(container, inv, name);
    }

    @Override
    protected GUI createGUI() {
        GUI gui = new GUI(0, 0, ConverterContainer.WIDTH, ConverterContainer.HEIGHT);
        gui.setContainer((WidgetContainer)this.menu);
        ConverterBlockEntity converter = (ConverterBlockEntity)((Object)((ConverterContainer)this.menu).getBlockEntity());
        WidgetRedstoneMode redstoneModeToggle = new WidgetRedstoneMode(converter.getRedstoneMode());
        redstoneModeToggle.setPosition(ConverterContainer.WIDTH - 20, 2);
        redstoneModeToggle.addListener(ValueChangedEvent.class, (event, widget) -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetRedstoneMode(converter.getBlockPos(), (RedstoneMode)((Object)((Object)redstoneModeToggle.getValue()))), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return WidgetEventResult.HANDLED;
        });
        gui.add(redstoneModeToggle);
        WidgetPatternMode clearPatternsToggle = new WidgetPatternMode(converter.clearPatterns);
        clearPatternsToggle.setPosition(ConverterContainer.WIDTH - 36, 5);
        clearPatternsToggle.addListener(ValueChangedEvent.class, (event, widget) -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetClearPatterns(converter.getBlockPos(), (Boolean)clearPatternsToggle.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return WidgetEventResult.HANDLED;
        });
        gui.add(clearPatternsToggle);
        WidgetProgressArrow progressArrow = new WidgetProgressArrow();
        progressArrow.setValue(100.0);
        progressArrow.setPosition(88, 30);
        gui.add(progressArrow);
        gui.addListener(GuiDataUpdatedEvent.class, (event, widget) -> {
            boolean isActive = converter.getRedstoneMode().resolve(converter.getLevel(), converter.getBlockPos());
            redstoneModeToggle.updateToolTips();
            redstoneModeToggle.addTooltipLine(new Component[]{isActive ? Component.translatable((String)"patternconverter.redstone_mode.redstone_active").withStyle(ChatFormatting.DARK_GREEN) : Component.translatable((String)"patternconverter.redstone_mode.redstone_inactive").withStyle(ChatFormatting.RED)});
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.fireDataUpdateEvent();
        return gui;
    }
}

