/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.blocks;

import com.davenonymous.patternconverter.api.plugin.IPatternConverter;
import com.davenonymous.patternconverter.blocks.ConverterBlockEntity;
import com.davenonymous.patternconverter.mods.PluginLoader;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.UnknownNullability;

public class ConverterInventories
implements INBTSerializable<CompoundTag> {
    public final ConverterBlockEntity converter;
    private final BiConsumer<ItemStackHandler, Integer> onChangeHandler;
    public ItemStackHandler queueInventory;
    public ItemStackHandler doneInventory;
    public ItemStackHandler patternInventory;
    public ItemStackHandler resultInventory;
    public CombinedInvWrapper inputInventories;
    public CombinedInvWrapper outputInventories;
    public CombinedInvWrapper accessibleInventories;

    public ConverterInventories(ConverterBlockEntity converter, BiConsumer<ItemStackHandler, Integer> onChangeHandler) {
        this.converter = converter;
        this.onChangeHandler = onChangeHandler;
        this.queueInventory = this.createQueueInventory();
        this.doneInventory = this.createDoneInventory();
        this.patternInventory = this.createPatternInventory();
        this.resultInventory = this.createResultInventory();
        this.inputInventories = this.createInputInventory();
        this.outputInventories = this.createOutputInventory();
        this.accessibleInventories = this.createCombinedInventory();
    }

    private ItemStackHandler createResultInventory() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                ConverterInventories.this.onChangeHandler.accept(this, slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Optional<IPatternConverter> optPatternHandler = PluginLoader.getPatternConverter(stack, ConverterInventories.this.converter.getLevel());
                if (optPatternHandler.isEmpty()) {
                    return false;
                }
                IPatternConverter patternHandler = optPatternHandler.get();
                if (!patternHandler.canRead()) {
                    return false;
                }
                if (!patternHandler.isPattern(stack, ConverterInventories.this.converter.getLevel())) {
                    return false;
                }
                return !patternHandler.isEmptyPattern(stack, ConverterInventories.this.converter.getLevel());
            }
        };
    }

    private ItemStackHandler createQueueInventory() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                ConverterInventories.this.onChangeHandler.accept(this, slot);
            }

            protected int getStackLimit(int slot, ItemStack stack) {
                return 1;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Optional<IPatternConverter> optPatternHandler = PluginLoader.getPatternConverter(stack, ConverterInventories.this.converter.getLevel());
                if (optPatternHandler.isEmpty()) {
                    return false;
                }
                IPatternConverter patternHandler = optPatternHandler.get();
                if (!patternHandler.canRead()) {
                    return false;
                }
                if (!patternHandler.isPattern(stack, ConverterInventories.this.converter.getLevel())) {
                    return false;
                }
                return !patternHandler.isEmptyPattern(stack, ConverterInventories.this.converter.getLevel());
            }
        };
    }

    private ItemStackHandler createDoneInventory() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                ConverterInventories.this.onChangeHandler.accept(this, slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Optional<IPatternConverter> optPatternHandler = PluginLoader.getPatternConverter(stack, ConverterInventories.this.converter.getLevel());
                if (optPatternHandler.isEmpty()) {
                    return false;
                }
                IPatternConverter patternHandler = optPatternHandler.get();
                if (!patternHandler.isPattern(stack, ConverterInventories.this.converter.getLevel())) {
                    return false;
                }
                return ConverterInventories.this.converter.clearPatterns || !patternHandler.isEmptyPattern(stack, ConverterInventories.this.converter.getLevel());
            }
        };
    }

    private ItemStackHandler createPatternInventory() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                ConverterInventories.this.onChangeHandler.accept(this, slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Optional<IPatternConverter> optPatternHandler = PluginLoader.getPatternConverter(stack, ConverterInventories.this.converter.getLevel());
                if (optPatternHandler.isEmpty()) {
                    return false;
                }
                IPatternConverter patternHandler = optPatternHandler.get();
                if (!patternHandler.canWrite()) {
                    return false;
                }
                if (!patternHandler.isPattern(stack, ConverterInventories.this.converter.getLevel())) {
                    return false;
                }
                return patternHandler.isEmptyPattern(stack, ConverterInventories.this.converter.getLevel());
            }
        };
    }

    private CombinedInvWrapper createInputInventory() {
        return new CombinedInvWrapper(this, new IItemHandlerModifiable[]{this.queueInventory, this.patternInventory}){

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.EMPTY;
            }
        };
    }

    private CombinedInvWrapper createOutputInventory() {
        return new CombinedInvWrapper(this, new IItemHandlerModifiable[]{this.doneInventory, this.resultInventory}){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }
        };
    }

    private CombinedInvWrapper createCombinedInventory() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventories, this.outputInventories});
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.put("queue", (Tag)this.queueInventory.serializeNBT(provider));
        tag.put("done", (Tag)this.doneInventory.serializeNBT(provider));
        tag.put("pattern", (Tag)this.patternInventory.serializeNBT(provider));
        tag.put("result", (Tag)this.resultInventory.serializeNBT(provider));
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.queueInventory.deserializeNBT(provider, compoundTag.getCompound("queue"));
        this.doneInventory.deserializeNBT(provider, compoundTag.getCompound("done"));
        this.patternInventory.deserializeNBT(provider, compoundTag.getCompound("pattern"));
        this.resultInventory.deserializeNBT(provider, compoundTag.getCompound("result"));
    }
}

