/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.blocks;

import com.davenonymous.patternconverter.api.IUniversalPattern;
import com.davenonymous.patternconverter.api.plugin.IPatternConverter;
import com.davenonymous.patternconverter.blocks.ConverterBlock;
import com.davenonymous.patternconverter.blocks.ConverterInventories;
import com.davenonymous.patternconverter.blocks.ConverterScreen;
import com.davenonymous.patternconverter.lib.BaseBlockEntity;
import com.davenonymous.patternconverter.lib.gui.RedstoneMode;
import com.davenonymous.patternconverter.mods.ConverterStyle;
import com.davenonymous.patternconverter.mods.PluginLoader;
import com.davenonymous.patternconverter.setup.ModBlocks;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ConverterBlockEntity
extends BaseBlockEntity {
    public final ConverterInventories inventories;
    private RedstoneMode redstoneMode = RedstoneMode.STOP_ON_POWER;
    boolean clearPatterns = false;

    public ConverterBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlocks.CONVERTER_ENTITY.get(), pos, blockState);
        this.inventories = new ConverterInventories(this, this::onInventoryChange);
    }

    private void onInventoryChange(ItemStackHandler handler, int slot) {
        this.setChanged();
        if (handler == this.inventories.patternInventory) {
            ItemStack patternStack = handler.getStackInSlot(0);
            if (patternStack.isEmpty()) {
                return;
            }
            Level level = this.getLevel();
            if (level == null) {
                return;
            }
            ConverterStyle style = PluginLoader.getPatternConverterStyle(patternStack, level);
            if (this.getBlockState().getValue(ConverterBlock.STYLE) != style) {
                BlockState newState = (BlockState)this.getBlockState().setValue(ConverterBlock.STYLE, (Comparable)((Object)style));
                level.setBlockAndUpdate(this.getBlockPos(), newState);
            }
        }
        this.notifyClients(false);
    }

    public ConverterBlockEntity setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.setChanged();
        this.notifyClients(false);
        return this;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void tick() {
        if (!this.getRedstoneMode().resolve(this.getLevel(), this.getBlockPos())) {
            return;
        }
        ItemStack blankPatterns = this.inventories.patternInventory.getStackInSlot(0);
        if (blankPatterns.isEmpty()) {
            return;
        }
        Optional<IPatternConverter> optWritePatternHandler = PluginLoader.getPatternConverter(blankPatterns, this.getLevel());
        if (optWritePatternHandler.isEmpty()) {
            return;
        }
        IPatternConverter writePatternHandler = optWritePatternHandler.get();
        if (!writePatternHandler.canWrite()) {
            return;
        }
        for (int queueSlot = 0; queueSlot < this.inventories.queueInventory.getSlots(); ++queueSlot) {
            ItemStack removedPattern;
            ItemStack insertedResultSim;
            ItemStack insertedSim;
            ItemStack originalRecipeSim;
            ItemStack resultStack;
            IUniversalPattern universalPattern;
            IPatternConverter patternHandler;
            Optional<IPatternConverter> optPatternHandler;
            ItemStack queueStack = this.inventories.queueInventory.getStackInSlot(queueSlot);
            if (queueStack.isEmpty() || (optPatternHandler = PluginLoader.getPatternConverter(queueStack, this.getLevel())).isEmpty() || !(patternHandler = optPatternHandler.get()).canRead() || (universalPattern = patternHandler.readPattern(queueStack, this.getLevel())) == null || (resultStack = writePatternHandler.writePattern(universalPattern, this.getLevel())) == null || resultStack.isEmpty() || (originalRecipeSim = this.inventories.queueInventory.extractItem(queueSlot, 1, true)).isEmpty()) continue;
            if (this.clearPatterns) {
                originalRecipeSim = new ItemStack((ItemLike)patternHandler.patternItem());
            }
            if (!(insertedSim = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventories.doneInventory, (ItemStack)originalRecipeSim, (boolean)true)).isEmpty() || !(insertedResultSim = ItemHandlerHelper.insertItem((IItemHandler)this.inventories.resultInventory, (ItemStack)resultStack, (boolean)true)).isEmpty() || (removedPattern = this.inventories.patternInventory.extractItem(0, 1, false)).isEmpty() || removedPattern.getCount() != 1) continue;
            ItemStack originalRecipe = this.inventories.queueInventory.extractItem(queueSlot, 1, false);
            if (this.clearPatterns) {
                originalRecipe = new ItemStack((ItemLike)patternHandler.patternItem());
            }
            ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventories.doneInventory, (ItemStack)originalRecipe, (boolean)false);
            ItemHandlerHelper.insertItem((IItemHandler)this.inventories.resultInventory, (ItemStack)resultStack, (boolean)false);
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof ConverterScreen) {
                ConverterScreen converterScreen = (ConverterScreen)screen;
                converterScreen.fireDataUpdateEvent();
            }
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventories.deserializeNBT(registries, tag.getCompound("inventories"));
        this.redstoneMode = RedstoneMode.byId(tag.getInt("redstoneMode"));
        this.clearPatterns = tag.contains("clearPatterns") ? tag.getBoolean("clearPatterns") : false;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventories", (Tag)this.inventories.serializeNBT(registries));
        tag.putInt("redstoneMode", this.redstoneMode.getId());
        if (this.clearPatterns) {
            tag.putBoolean("clearPatterns", true);
        }
    }

    public boolean shouldClearPatterns() {
        return this.clearPatterns;
    }

    public ConverterBlockEntity setClearPatterns(boolean clearPatterns) {
        this.clearPatterns = clearPatterns;
        this.setChanged();
        this.notifyClients(false);
        return this;
    }

    public static IItemHandler getCapability(Level level, BlockPos pos, BlockState state, BlockEntity entity, Direction side) {
        if (!(entity instanceof ConverterBlockEntity)) {
            return null;
        }
        ConverterBlockEntity converter = (ConverterBlockEntity)entity;
        if (side == null) {
            return converter.inventories.accessibleInventories;
        }
        switch (side) {
            case UP: {
                return converter.inventories.inputInventories;
            }
            case DOWN: {
                return converter.inventories.outputInventories;
            }
        }
        return converter.inventories.accessibleInventories;
    }
}

