/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.blocks;

import com.davenonymous.patternconverter.blocks.ConverterBlockEntity;
import com.davenonymous.patternconverter.blocks.ConverterContainer;
import com.davenonymous.patternconverter.datacomponents.ConverterStyleDataComponent;
import com.davenonymous.patternconverter.mods.ConverterStyle;
import com.davenonymous.patternconverter.setup.ModBlocks;
import com.davenonymous.patternconverter.setup.ModDataComponents;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ConverterBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<ConverterStyle> STYLE = EnumProperty.create((String)"style", ConverterStyle.class);
    private final VoxelShape SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public ConverterBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.METAL).strength(5.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STYLE, (Comparable)((Object)ConverterStyle.INTEGRATED_DYNAMICS)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction forward = context.getHorizontalDirection().getOpposite();
        Player player = context.getPlayer();
        if (player != null) {
            if (player.getXRot() > 65.0f) {
                forward = Direction.UP;
            } else if (player.getXRot() < -65.0f) {
                forward = Direction.DOWN;
            }
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)forward);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{STYLE});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == ModBlocks.CONVERTER_ENTITY.get()) {
            return (level1, blockPos, blockState, blockEntity) -> {
                if (blockEntity instanceof ConverterBlockEntity) {
                    ConverterBlockEntity converter = (ConverterBlockEntity)blockEntity;
                    converter.tick();
                }
            };
        }
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ConverterBlockEntity) {
            ConverterBlockEntity converter = (ConverterBlockEntity)blockEntity;
            player.openMenu(state.getMenuProvider(level, pos), pos);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (level.isClientSide()) {
            return;
        }
        if (!stack.has((DataComponentType)ModDataComponents.CONVERTER_STYLE_COMPONENT.get())) {
            return;
        }
        ConverterStyle style = ((ConverterStyleDataComponent)stack.get((DataComponentType)ModDataComponents.CONVERTER_STYLE_COMPONENT.get())).style();
        state = (BlockState)state.setValue(STYLE, (Comparable)((Object)style));
        level.setBlockAndUpdate(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ConverterBlockEntity)) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        ConverterBlockEntity converter = (ConverterBlockEntity)blockEntity;
        if (!state.hasProperty(STYLE)) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        ConverterStyle style = (ConverterStyle)((Object)state.getValue(STYLE));
        ItemStack clone = new ItemStack((ItemLike)this, 1);
        clone.set((DataComponentType)ModDataComponents.CONVERTER_STYLE_COMPONENT.get(), (Object)new ConverterStyleDataComponent(style));
        return clone;
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new ConverterContainer(id, pos, inventory, player), (Component)Component.translatable((String)"container.patternconverter.converter"));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ConverterBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.SHAPE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected MapCodec<? extends Block> codec() {
        return (MapCodec)ModBlocks.CONVERTER_BLOCK_TYPE.get();
    }
}

