/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.wrapper;

import com.davenonymous.patternconverter.api.wrapper.ItemTagIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class UniversalItemIngredient {
    public static final UniversalItemIngredient EMPTY = new UniversalItemIngredient(Ingredient.EMPTY);
    ItemStack stack = ItemStack.EMPTY;
    Ingredient ingredient = Ingredient.EMPTY;
    ItemTagIngredient itemTagIngredient = ItemTagIngredient.EMPTY;

    public UniversalItemIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public UniversalItemIngredient(ItemStack stack) {
        this.stack = stack;
    }

    public UniversalItemIngredient(ItemTagIngredient itemTagIngredient) {
        this.itemTagIngredient = itemTagIngredient;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.stack.isEmpty() && this.ingredient.isEmpty() && this.itemTagIngredient.isEmpty();
    }

    public boolean isStack() {
        return !this.stack.isEmpty();
    }

    public boolean isIngredient() {
        return !this.ingredient.isEmpty();
    }

    public boolean isTagIngredient() {
        return !this.itemTagIngredient.isEmpty();
    }

    public Ingredient ingredient() {
        return this.ingredient;
    }

    public ItemStack stack() {
        return this.stack;
    }

    public ItemTagIngredient tagIngredient() {
        return this.itemTagIngredient;
    }

    public ItemStack primary() {
        if (!this.stack.isEmpty()) {
            return this.stack.copy();
        }
        if (!this.ingredient.isEmpty()) {
            return this.ingredient.getItems()[0].copy();
        }
        if (!this.itemTagIngredient.isEmpty()) {
            return this.itemTagIngredient.representativeItem.copy();
        }
        return ItemStack.EMPTY;
    }
}

