/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.wrapper;

import com.davenonymous.patternconverter.api.wrapper.TagMatchingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ItemTagIngredient {
    public ItemStack representativeItem = ItemStack.EMPTY;
    public List<String> tags = new ArrayList<String>();
    public TagMatchingMode mode;
    public long amount = 1L;
    public static ItemTagIngredient EMPTY = new ItemTagIngredient(new String[0]);

    public ItemTagIngredient(ItemStack stack, List<String> alternativeTags) {
        this.mode = TagMatchingMode.ANY;
        this.representativeItem = stack;
        this.tags.addAll(alternativeTags);
    }

    public ItemTagIngredient(ItemStack stack, List<String> alternativeTags, TagMatchingMode mode) {
        this.mode = mode;
        this.representativeItem = stack;
        this.tags.addAll(alternativeTags);
    }

    public ItemTagIngredient(TagMatchingMode mode, List<String> tags) {
        this.mode = mode;
        this.tags = tags;
    }

    public ItemTagIngredient(TagMatchingMode mode, String ... tags) {
        this.mode = mode;
        this.tags.addAll(Arrays.asList(tags));
    }

    public ItemTagIngredient(String ... tags) {
        this(TagMatchingMode.ANY, tags);
    }

    public ItemTagIngredient setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    public ItemTagIngredient setMode(TagMatchingMode mode) {
        this.mode = mode;
        return this;
    }

    public ItemTagIngredient setRepresentativeItem(ItemStack representativeItem) {
        this.representativeItem = representativeItem;
        return this;
    }

    public boolean isEmpty() {
        return this.representativeItem.isEmpty() || this.amount <= 0L || this.tags.isEmpty();
    }
}

