/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.wrapper;

import com.davenonymous.patternconverter.api.wrapper.TagMatchingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidTagIngredient {
    public FluidStack representativeFluid = FluidStack.EMPTY;
    public List<String> tags = new ArrayList<String>();
    public TagMatchingMode mode;
    public long amount = 1L;
    public static FluidTagIngredient EMPTY = new FluidTagIngredient(new String[0]);

    public FluidTagIngredient(FluidStack stack, List<String> alternativeTags) {
        this.mode = TagMatchingMode.ANY;
        this.representativeFluid = stack;
        this.tags.addAll(alternativeTags);
    }

    public FluidTagIngredient(FluidStack stack, List<String> alternativeTags, TagMatchingMode mode) {
        this.mode = mode;
        this.representativeFluid = stack;
        this.tags.addAll(alternativeTags);
    }

    public FluidTagIngredient(TagMatchingMode mode, List<String> tags) {
        this.mode = mode;
        this.tags = tags;
    }

    public FluidTagIngredient(TagMatchingMode mode, String ... tags) {
        this.mode = mode;
        this.tags.addAll(Arrays.asList(tags));
    }

    public FluidTagIngredient(String ... tags) {
        this(TagMatchingMode.ANY, tags);
    }

    public FluidTagIngredient setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    public FluidTagIngredient setMode(TagMatchingMode mode) {
        this.mode = mode;
        return this;
    }

    public FluidTagIngredient setRepresentativeItem(FluidStack representativeItem) {
        this.representativeFluid = representativeItem;
        return this;
    }

    public boolean isEmpty() {
        return this.representativeFluid.isEmpty() || this.amount <= 0L || this.tags.isEmpty();
    }
}

