/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.types;

import com.davenonymous.patternconverter.api.IUniversalPattern;
import com.davenonymous.patternconverter.api.wrapper.FluidTagIngredient;
import com.davenonymous.patternconverter.api.wrapper.ItemTagIngredient;
import com.davenonymous.patternconverter.api.wrapper.UniversalFluidIngredient;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;

public interface IUniversalProcessingPattern
extends IUniversalPattern {
    public long inputEnergy();

    public long outputEnergy();

    public List<FluidStack> inputFluids();

    public List<FluidStack> outputFluids();

    public List<UniversalItemIngredient> inputIngredients();

    public List<UniversalFluidIngredient> inputUniversalFluids();

    public void addInput(FluidStack var1);

    public void addOutput(FluidStack var1);

    public void addInputEnergy(long var1);

    public void addOutputEnergy(long var1);

    public void addInput(UniversalItemIngredient var1);

    public void addInput(UniversalFluidIngredient var1);

    default public void addInput(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        this.addInput(new UniversalItemIngredient(stack));
    }

    default public void addInput(ItemTagIngredient tag) {
        if (tag.isEmpty()) {
            return;
        }
        this.addInput(new UniversalItemIngredient(tag));
    }

    default public void addInput(FluidTagIngredient tag) {
        if (tag.isEmpty()) {
            return;
        }
        this.addInput(new UniversalFluidIngredient(tag));
    }

    default public void addInput(Ingredient ingredient) {
        if (ingredient.isEmpty()) {
            return;
        }
        this.addInput(new UniversalItemIngredient(ingredient));
    }
}

