/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.plugin;

import com.davenonymous.patternconverter.api.IUniversalPattern;
import com.davenonymous.patternconverter.api.types.IUniversalCraftingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalProcessingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalSmithingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalStonecutterPattern;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface IPatternConverter {
    public Item patternItem();

    default public Optional<ResourceKey<CreativeModeTab>> creativeTab() {
        return Optional.empty();
    }

    default public boolean canRead() {
        return true;
    }

    default public boolean canWrite() {
        return true;
    }

    default public boolean isPattern(ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getItem() == this.patternItem();
    }

    public boolean isEmptyPattern(ItemStack var1, Level var2);

    public IUniversalPattern readPattern(ItemStack var1, Level var2);

    default public ItemStack writePattern(IUniversalPattern pattern, Level level) {
        if (pattern instanceof IUniversalCraftingPattern) {
            IUniversalCraftingPattern craftingPattern = (IUniversalCraftingPattern)pattern;
            return this.writePattern(craftingPattern, level);
        }
        if (pattern instanceof IUniversalProcessingPattern) {
            IUniversalProcessingPattern processingPattern = (IUniversalProcessingPattern)pattern;
            return this.writePattern(processingPattern, level);
        }
        if (pattern instanceof IUniversalStonecutterPattern) {
            IUniversalStonecutterPattern stonecutterPattern = (IUniversalStonecutterPattern)pattern;
            return this.writePattern(stonecutterPattern, level);
        }
        if (pattern instanceof IUniversalSmithingPattern) {
            IUniversalSmithingPattern smithingPattern = (IUniversalSmithingPattern)pattern;
            return this.writePattern(smithingPattern, level);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack writePattern(IUniversalProcessingPattern var1, Level var2);

    public ItemStack writePattern(IUniversalCraftingPattern var1, Level var2);

    public ItemStack writePattern(IUniversalStonecutterPattern var1, Level var2);

    public ItemStack writePattern(IUniversalSmithingPattern var1, Level var2);
}

