/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.impl;

import com.davenonymous.patternconverter.api.AbstractUniversalPattern;
import com.davenonymous.patternconverter.api.IUniversalPattern;
import com.davenonymous.patternconverter.api.impl.UniversalCraftingPattern;
import com.davenonymous.patternconverter.api.impl.UniversalProcessingPattern;
import com.davenonymous.patternconverter.api.impl.UniversalSmithingPattern;
import com.davenonymous.patternconverter.api.impl.UniversalStonecutterPattern;
import com.davenonymous.patternconverter.api.types.IUniversalCraftingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalProcessingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalSmithingPattern;
import com.davenonymous.patternconverter.api.types.IUniversalStonecutterPattern;
import com.davenonymous.patternconverter.api.wrapper.ItemTagIngredient;
import com.davenonymous.patternconverter.api.wrapper.UniversalFluidIngredient;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class UniversalSuperPattern
extends AbstractUniversalPattern
implements IUniversalCraftingPattern,
IUniversalProcessingPattern,
IUniversalStonecutterPattern,
IUniversalSmithingPattern {
    private int patternWidth = 0;
    private int patternHeight = 0;
    private Map<Integer, UniversalItemIngredient> shapedInputUniversalItems = new HashMap<Integer, UniversalItemIngredient>();
    private RecipeHolder<CraftingRecipe> craftingRecipe = null;
    private long inputEnergy = 0L;
    private long outputEnergy = 0L;
    private List<FluidStack> inputFluids = new ArrayList<FluidStack>();
    private List<FluidStack> outputFluids = new ArrayList<FluidStack>();
    private List<UniversalItemIngredient> inputUniversalItems = new ArrayList<UniversalItemIngredient>();
    private List<UniversalFluidIngredient> inputUniversalFluids = new ArrayList<UniversalFluidIngredient>();
    private RecipeHolder<SmithingRecipe> smithingRecipe = null;
    private UniversalItemIngredient template = UniversalItemIngredient.EMPTY;
    private UniversalItemIngredient base = UniversalItemIngredient.EMPTY;
    private UniversalItemIngredient addition = UniversalItemIngredient.EMPTY;
    private RecipeHolder<StonecutterRecipe> stonecutterRecipe = null;
    private UniversalItemIngredient stone = UniversalItemIngredient.EMPTY;

    public Optional<IUniversalPattern> guessRecipe(Level level) {
        if (this.outputIngredients().size() == 1 && this.inputEnergy == 0L && this.outputEnergy == 0L && this.outputFluids.isEmpty() && this.inputFluids.isEmpty()) {
            SmithingRecipeInput smithingInput = this.createSmithingInput();
            for (Object recipe : level.getRecipeManager().getAllRecipesFor(RecipeType.SMITHING)) {
                ItemStack resultStack = ((SmithingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                if (!ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)this.getPrimaryOutputStack()) || !((SmithingRecipe)recipe.value()).matches((RecipeInput)smithingInput, level)) continue;
                UniversalSmithingPattern result = new UniversalSmithingPattern(this.shapedInputUniversalItems.getOrDefault(0, UniversalItemIngredient.EMPTY).primary(), this.shapedInputUniversalItems.getOrDefault(1, UniversalItemIngredient.EMPTY).primary(), this.shapedInputUniversalItems.getOrDefault(2, UniversalItemIngredient.EMPTY).primary());
                result.setRecipe((RecipeHolder<SmithingRecipe>)recipe);
                result.addOutput(resultStack.copy());
                return Optional.of(result);
            }
            SingleRecipeInput cuttingInput = this.createCuttingInput();
            for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(RecipeType.STONECUTTING)) {
                ItemStack resultStack = ((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                if (!ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)this.getPrimaryOutputStack()) || !((StonecutterRecipe)recipe.value()).matches(cuttingInput, level)) continue;
                UniversalStonecutterPattern result = new UniversalStonecutterPattern(cuttingInput.item());
                result.setRecipe((RecipeHolder<StonecutterRecipe>)recipe);
                result.addOutput(resultStack.copy());
                return Optional.of(result);
            }
            CraftingInput craftingInput = this.createCraftingInput();
            for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING)) {
                ItemStack resultStack = ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                if (!ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)this.getPrimaryOutputStack()) || !((CraftingRecipe)recipe.value()).matches((RecipeInput)craftingInput, level)) continue;
                UniversalCraftingPattern result = new UniversalCraftingPattern(craftingInput);
                result.setRecipe((RecipeHolder<CraftingRecipe>)recipe);
                result.addOutput(resultStack.copy());
                return Optional.of(result);
            }
        }
        return Optional.of(new UniversalProcessingPattern(this));
    }

    @Override
    public RecipeHolder<CraftingRecipe> craftingRecipe() {
        if (this.craftingRecipe == null) {
            // empty if block
        }
        return this.craftingRecipe;
    }

    @Override
    public Map<Integer, UniversalItemIngredient> shapedInputIngredients() {
        return this.shapedInputUniversalItems;
    }

    @Override
    public int patternWidth() {
        return this.patternWidth;
    }

    @Override
    public int patternHeight() {
        return this.patternHeight;
    }

    public void setPatternHeight(int patternHeight) {
        this.patternHeight = patternHeight;
    }

    public void setPatternWidth(int patternWidth) {
        this.patternWidth = patternWidth;
    }

    @Override
    public void setInputStacks(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        for (int slot = 0; slot < stacks.size(); ++slot) {
            ItemStack ingredient = stacks.get(slot);
            if (ingredient.isEmpty()) continue;
            this.addInput(slot, ingredient);
        }
    }

    @Override
    public void setInputIngredients(List<Ingredient> ingredients) {
        if (ingredients.isEmpty()) {
            return;
        }
        for (int slot = 0; slot < ingredients.size(); ++slot) {
            Ingredient ingredient = ingredients.get(slot);
            if (ingredient.isEmpty()) continue;
            this.addInput(slot, ingredient);
        }
    }

    @Override
    public void setInputTags(List<ItemTagIngredient> tags) {
        if (tags.isEmpty()) {
            return;
        }
        for (int slot = 0; slot < tags.size(); ++slot) {
            ItemTagIngredient tag = tags.get(slot);
            if (tag.isEmpty()) continue;
            this.addInput(slot, tag);
        }
    }

    @Override
    public void addInput(int slot, UniversalItemIngredient input) {
        if (input.isEmpty()) {
            return;
        }
        int col = slot % 3;
        int row = slot / 3;
        this.patternWidth = Math.max(this.patternWidth, col + 1);
        this.patternHeight = Math.max(this.patternHeight, row + 1);
        this.shapedInputUniversalItems.put(slot, input);
        this.hasInput = true;
    }

    @Override
    public List<ItemStack> getAllInputsAsItemStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int col = 0; col < this.patternWidth; ++col) {
            for (int row = 0; row < this.patternHeight; ++row) {
                int slot = row * this.patternWidth + col;
                if (!this.shapedInputUniversalItems.containsKey(slot)) {
                    stacks.add(ItemStack.EMPTY);
                    continue;
                }
                UniversalItemIngredient ingredient = this.shapedInputUniversalItems.get(slot);
                if (ingredient.isEmpty()) {
                    stacks.add(ItemStack.EMPTY);
                    continue;
                }
                stacks.add(ingredient.primary());
            }
        }
        return stacks;
    }

    @Override
    public List<UniversalItemIngredient> getAs3by3() {
        ArrayList<UniversalItemIngredient> stacks = new ArrayList<UniversalItemIngredient>();
        for (int col = 0; col < this.patternWidth; ++col) {
            for (int row = 0; row < this.patternHeight; ++row) {
                int slot = row * 3 + col;
                if (!this.shapedInputUniversalItems.containsKey(slot)) {
                    stacks.add(UniversalItemIngredient.EMPTY);
                    continue;
                }
                UniversalItemIngredient ingredient = this.shapedInputUniversalItems.get(slot);
                if (ingredient.isEmpty()) {
                    stacks.add(UniversalItemIngredient.EMPTY);
                    continue;
                }
                stacks.add(ingredient);
            }
        }
        return stacks;
    }

    @Override
    public CraftingInput createCraftingInput() {
        ArrayList<ItemStack> craftingStacks = new ArrayList<ItemStack>();
        for (int slot = 0; slot < 9; ++slot) {
            int col = slot % 3;
            int row = slot / 3;
            if (col >= this.patternWidth || row >= this.patternHeight) continue;
            if (!this.shapedInputUniversalItems.containsKey(slot)) {
                craftingStacks.add(ItemStack.EMPTY);
                continue;
            }
            UniversalItemIngredient ingredient = this.shapedInputUniversalItems.get(slot);
            if (ingredient.isEmpty()) {
                craftingStacks.add(ItemStack.EMPTY);
                continue;
            }
            craftingStacks.add(ingredient.primary());
        }
        return CraftingInput.of((int)this.patternWidth, (int)this.patternHeight, craftingStacks);
    }

    @Override
    public long inputEnergy() {
        return this.inputEnergy;
    }

    @Override
    public List<FluidStack> inputFluids() {
        return this.inputFluids;
    }

    @Override
    public long outputEnergy() {
        return this.outputEnergy;
    }

    @Override
    public List<FluidStack> outputFluids() {
        return this.outputFluids;
    }

    @Override
    public List<UniversalItemIngredient> inputIngredients() {
        return this.inputUniversalItems;
    }

    @Override
    public List<UniversalFluidIngredient> inputUniversalFluids() {
        return this.inputUniversalFluids;
    }

    @Override
    public void addInput(FluidStack fluid) {
        this.inputFluids.add(fluid.copy());
    }

    @Override
    public void addOutput(FluidStack fluid) {
        this.outputFluids.add(fluid.copy());
    }

    @Override
    public void addInputEnergy(long energy) {
        this.inputEnergy += energy;
    }

    @Override
    public void addOutputEnergy(long energy) {
        this.outputEnergy += energy;
    }

    @Override
    public void addInput(UniversalItemIngredient ingredient) {
        this.inputUniversalItems.add(ingredient);
    }

    @Override
    public void addInput(UniversalFluidIngredient ingredient) {
        this.inputUniversalFluids.add(ingredient);
    }

    @Override
    public UniversalItemIngredient getAddition() {
        return this.addition;
    }

    @Override
    public UniversalItemIngredient getBase() {
        return this.base;
    }

    @Override
    public UniversalItemIngredient getTemplate() {
        return this.template;
    }

    @Override
    public SmithingRecipeInput createSmithingInput() {
        return new SmithingRecipeInput(this.shapedInputUniversalItems.getOrDefault(0, UniversalItemIngredient.EMPTY).primary(), this.shapedInputUniversalItems.getOrDefault(1, UniversalItemIngredient.EMPTY).primary(), this.shapedInputUniversalItems.getOrDefault(2, UniversalItemIngredient.EMPTY).primary());
    }

    @Override
    public RecipeHolder<SmithingRecipe> smithingRecipe() {
        return this.smithingRecipe;
    }

    @Override
    public UniversalItemIngredient input() {
        return this.base;
    }

    @Override
    public SingleRecipeInput createCuttingInput() {
        return new SingleRecipeInput(this.shapedInputUniversalItems.getOrDefault(0, UniversalItemIngredient.EMPTY).primary());
    }

    @Override
    public RecipeHolder<StonecutterRecipe> stoneCutterRecipe() {
        return this.stonecutterRecipe;
    }
}

