/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.impl;

import com.davenonymous.patternconverter.api.AbstractUniversalPattern;
import com.davenonymous.patternconverter.api.types.IUniversalStonecutterPattern;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;

public class UniversalStonecutterPattern
extends AbstractUniversalPattern
implements IUniversalStonecutterPattern {
    private RecipeHolder<StonecutterRecipe> recipe = null;
    private UniversalItemIngredient base = UniversalItemIngredient.EMPTY;

    public UniversalStonecutterPattern(UniversalItemIngredient base) {
        this.base = base;
    }

    public UniversalStonecutterPattern(ItemStack base) {
        this(new UniversalItemIngredient(base));
    }

    public void guessRecipe(Level level) {
        SingleRecipeInput cuttingInput = this.createCuttingInput();
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(RecipeType.STONECUTTING)) {
            ItemStack resultStack = ((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            if (!ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)this.getPrimaryOutputStack()) || !((StonecutterRecipe)recipe.value()).matches(cuttingInput, level)) continue;
            this.recipe = recipe;
        }
    }

    public UniversalStonecutterPattern setRecipe(RecipeHolder<StonecutterRecipe> recipe) {
        this.recipe = recipe;
        return this;
    }

    @Override
    public UniversalItemIngredient input() {
        return this.base;
    }

    @Override
    public SingleRecipeInput createCuttingInput() {
        return new SingleRecipeInput(this.base.primary());
    }

    @Override
    public RecipeHolder<StonecutterRecipe> stoneCutterRecipe() {
        return this.recipe;
    }
}

