/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.impl;

import com.davenonymous.patternconverter.api.AbstractUniversalPattern;
import com.davenonymous.patternconverter.api.types.IUniversalSmithingPattern;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public class UniversalSmithingPattern
extends AbstractUniversalPattern
implements IUniversalSmithingPattern {
    private RecipeHolder<SmithingRecipe> recipe = null;
    private UniversalItemIngredient template = UniversalItemIngredient.EMPTY;
    private UniversalItemIngredient base = UniversalItemIngredient.EMPTY;
    private UniversalItemIngredient addition = UniversalItemIngredient.EMPTY;

    public UniversalSmithingPattern(ItemStack templateItem, ItemStack baseItem, ItemStack additionItem) {
        this(new UniversalItemIngredient(templateItem), new UniversalItemIngredient(baseItem), new UniversalItemIngredient(additionItem));
    }

    public UniversalSmithingPattern(UniversalItemIngredient template, UniversalItemIngredient base, UniversalItemIngredient addition) {
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public void guessRecipe(Level level) {
        SmithingRecipeInput smithingInput = this.createSmithingInput();
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(RecipeType.SMITHING)) {
            ItemStack resultStack = ((SmithingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            if (!ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)this.getPrimaryOutputStack()) || !((SmithingRecipe)recipe.value()).matches((RecipeInput)smithingInput, level)) continue;
            this.setRecipe((RecipeHolder<SmithingRecipe>)recipe);
            break;
        }
    }

    public UniversalSmithingPattern setRecipe(RecipeHolder<SmithingRecipe> recipe) {
        this.recipe = recipe;
        return this;
    }

    @Override
    public UniversalItemIngredient getAddition() {
        return this.addition;
    }

    @Override
    public UniversalItemIngredient getBase() {
        return this.base;
    }

    @Override
    public UniversalItemIngredient getTemplate() {
        return this.template;
    }

    @Override
    public SmithingRecipeInput createSmithingInput() {
        return new SmithingRecipeInput(this.template.primary(), this.base.primary(), this.addition.primary());
    }

    @Override
    public RecipeHolder<SmithingRecipe> smithingRecipe() {
        return this.recipe;
    }
}

