/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.impl;

import com.davenonymous.patternconverter.api.AbstractUniversalPattern;
import com.davenonymous.patternconverter.api.impl.UniversalSuperPattern;
import com.davenonymous.patternconverter.api.types.IUniversalProcessingPattern;
import com.davenonymous.patternconverter.api.wrapper.UniversalFluidIngredient;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.neoforged.neoforge.fluids.FluidStack;

public class UniversalProcessingPattern
extends AbstractUniversalPattern
implements IUniversalProcessingPattern {
    private long inputEnergy = 0L;
    private long outputEnergy = 0L;
    private List<FluidStack> inputFluids = new ArrayList<FluidStack>();
    private List<FluidStack> outputFluids = new ArrayList<FluidStack>();
    private List<UniversalItemIngredient> inputUniversalItems = new ArrayList<UniversalItemIngredient>();
    private List<UniversalFluidIngredient> inputUniversalFluids = new ArrayList<UniversalFluidIngredient>();

    public UniversalProcessingPattern() {
    }

    public UniversalProcessingPattern(UniversalSuperPattern superPattern) {
        this.inputEnergy = superPattern.inputEnergy();
        this.outputEnergy = superPattern.outputEnergy();
        this.inputFluids.addAll(superPattern.inputFluids());
        this.outputFluids.addAll(superPattern.outputFluids());
        this.inputUniversalItems.addAll(superPattern.shapedInputIngredients().values().stream().filter(Predicate.not(UniversalItemIngredient::isEmpty)).toList());
        this.inputUniversalFluids.addAll(superPattern.inputUniversalFluids().stream().filter(Predicate.not(UniversalFluidIngredient::isEmpty)).toList());
        this.outputIngredients.addAll(superPattern.outputIngredients());
    }

    @Override
    public long inputEnergy() {
        return this.inputEnergy;
    }

    @Override
    public List<FluidStack> inputFluids() {
        return this.inputFluids;
    }

    @Override
    public long outputEnergy() {
        return this.outputEnergy;
    }

    @Override
    public List<FluidStack> outputFluids() {
        return this.outputFluids;
    }

    @Override
    public List<UniversalItemIngredient> inputIngredients() {
        return this.inputUniversalItems;
    }

    @Override
    public List<UniversalFluidIngredient> inputUniversalFluids() {
        return this.inputUniversalFluids;
    }

    @Override
    public void addInput(FluidStack fluid) {
        this.inputFluids.add(fluid.copy());
    }

    @Override
    public void addOutput(FluidStack fluid) {
        this.outputFluids.add(fluid.copy());
    }

    @Override
    public void addInputEnergy(long energy) {
        this.inputEnergy += energy;
    }

    @Override
    public void addOutputEnergy(long energy) {
        this.outputEnergy += energy;
    }

    @Override
    public void addInput(UniversalItemIngredient ingredient) {
        this.inputUniversalItems.add(ingredient);
    }

    @Override
    public void addInput(UniversalFluidIngredient ingredient) {
        this.inputUniversalFluids.add(ingredient);
    }
}

