/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api.impl;

import com.davenonymous.patternconverter.api.AbstractUniversalPattern;
import com.davenonymous.patternconverter.api.types.IUniversalCraftingPattern;
import com.davenonymous.patternconverter.api.wrapper.ItemTagIngredient;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class UniversalCraftingPattern
extends AbstractUniversalPattern
implements IUniversalCraftingPattern {
    private int patternWidth = 3;
    private int patternHeight = 3;
    private Map<Integer, UniversalItemIngredient> shapedInputUniversalItems = new HashMap<Integer, UniversalItemIngredient>();
    private RecipeHolder<CraftingRecipe> craftingRecipe = null;

    public UniversalCraftingPattern() {
    }

    public UniversalCraftingPattern(CraftingInput craftingInput) {
        this.patternWidth = craftingInput.width();
        this.patternHeight = craftingInput.height();
        this.setInputStacks(craftingInput.items());
    }

    @Override
    public RecipeHolder<CraftingRecipe> craftingRecipe() {
        return this.craftingRecipe;
    }

    public void guessRecipe(Level level) {
        CraftingInput craftingInput = this.createCraftingInput();
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING)) {
            ItemStack resultStack = ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            if (resultStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)this.getPrimaryOutputStack()) || !((CraftingRecipe)recipe.value()).matches((RecipeInput)craftingInput, level)) continue;
            this.craftingRecipe = recipe;
            break;
        }
    }

    @Override
    public Map<Integer, UniversalItemIngredient> shapedInputIngredients() {
        return this.shapedInputUniversalItems;
    }

    @Override
    public int patternWidth() {
        return this.patternWidth;
    }

    @Override
    public int patternHeight() {
        return this.patternHeight;
    }

    public UniversalCraftingPattern setRecipe(RecipeHolder<CraftingRecipe> craftingRecipe) {
        this.craftingRecipe = craftingRecipe;
        return this;
    }

    public UniversalCraftingPattern setPatternHeight(int patternHeight) {
        this.patternHeight = patternHeight;
        return this;
    }

    public UniversalCraftingPattern setPatternWidth(int patternWidth) {
        this.patternWidth = patternWidth;
        return this;
    }

    @Override
    public void setInputStacks(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        for (int slot = 0; slot < stacks.size(); ++slot) {
            ItemStack ingredient = stacks.get(slot);
            this.addInput(slot, ingredient);
        }
    }

    @Override
    public void setInputIngredients(List<Ingredient> ingredients) {
        if (ingredients.isEmpty()) {
            return;
        }
        for (int slot = 0; slot < ingredients.size(); ++slot) {
            Ingredient ingredient = ingredients.get(slot);
            this.addInput(slot, ingredient);
        }
    }

    @Override
    public void setInputTags(List<ItemTagIngredient> tags) {
        if (tags.isEmpty()) {
            return;
        }
        for (int slot = 0; slot < tags.size(); ++slot) {
            ItemTagIngredient tag = tags.get(slot);
            this.addInput(slot, tag);
        }
    }

    @Override
    public void addInput(int slot, UniversalItemIngredient input) {
        if (input.isEmpty()) {
            return;
        }
        this.shapedInputUniversalItems.put(slot, input);
        this.hasInput = true;
    }

    @Override
    public List<ItemStack> getAllInputsAsItemStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int row = 0; row < this.patternHeight; ++row) {
            for (int col = 0; col < this.patternWidth; ++col) {
                int slot = row * this.patternWidth + col;
                if (!this.shapedInputUniversalItems.containsKey(slot)) {
                    stacks.add(ItemStack.EMPTY);
                    continue;
                }
                UniversalItemIngredient ingredient = this.shapedInputUniversalItems.get(slot);
                if (ingredient.isEmpty()) {
                    stacks.add(ItemStack.EMPTY);
                    continue;
                }
                stacks.add(ingredient.primary());
            }
        }
        return stacks;
    }

    @Override
    public List<UniversalItemIngredient> getAs3by3() {
        ArrayList<UniversalItemIngredient> stacks = new ArrayList<UniversalItemIngredient>();
        for (int slot = 0; slot < 9; ++slot) {
            int col = slot % 3;
            int row = slot / 3;
            int transformedSlot = slot;
            if (this.patternWidth == 2) {
                transformedSlot = slot - row;
            }
            if (this.patternWidth == 1) {
                transformedSlot = slot - 2 * row;
            }
            if (col >= this.patternWidth || row >= this.patternHeight) {
                stacks.add(UniversalItemIngredient.EMPTY);
                continue;
            }
            if (!this.shapedInputUniversalItems.containsKey(transformedSlot)) {
                stacks.add(UniversalItemIngredient.EMPTY);
                continue;
            }
            UniversalItemIngredient ingredient = this.shapedInputUniversalItems.get(transformedSlot);
            if (ingredient.isEmpty()) {
                stacks.add(UniversalItemIngredient.EMPTY);
                continue;
            }
            stacks.add(ingredient);
        }
        return stacks;
    }

    @Override
    public CraftingInput createCraftingInput() {
        return CraftingInput.of((int)this.patternWidth, (int)this.patternHeight, this.getAllInputsAsItemStacks());
    }
}

