/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.patternconverter.api;

import com.davenonymous.patternconverter.api.IUniversalPattern;
import com.davenonymous.patternconverter.api.wrapper.ItemTagIngredient;
import com.davenonymous.patternconverter.api.wrapper.UniversalItemIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class AbstractUniversalPattern
implements IUniversalPattern {
    protected List<UniversalItemIngredient> outputIngredients = new ArrayList<UniversalItemIngredient>();
    protected boolean allItemsFuzzy = false;
    protected boolean allFluidsFuzzy = false;
    protected boolean hasOutput = false;
    protected boolean hasInput = false;

    public AbstractUniversalPattern setAllItemsFuzzy(boolean allItemsFuzzy) {
        this.allItemsFuzzy = allItemsFuzzy;
        return this;
    }

    @Override
    public boolean areAllItemsFuzzy() {
        return this.allItemsFuzzy;
    }

    public AbstractUniversalPattern setAllFluidsFuzzy(boolean allFluidsFuzzy) {
        this.allFluidsFuzzy = allFluidsFuzzy;
        return this;
    }

    @Override
    public boolean areAllFluidsFuzzy() {
        return this.allFluidsFuzzy;
    }

    @Override
    public boolean isValid() {
        return this.hasInput && this.hasOutput;
    }

    @Override
    public List<UniversalItemIngredient> outputIngredients() {
        return this.outputIngredients;
    }

    @Override
    public void addOutput(UniversalItemIngredient output) {
        if (output.isEmpty()) {
            return;
        }
        this.outputIngredients.add(output);
        this.hasOutput = true;
    }

    @Override
    public void addOutput(Ingredient output) {
        if (output.isEmpty()) {
            return;
        }
        this.addOutput(new UniversalItemIngredient(output));
    }

    @Override
    public void addOutput(ItemStack output) {
        if (output.isEmpty()) {
            return;
        }
        this.addOutput(new UniversalItemIngredient(output));
    }

    @Override
    public void addOutput(ItemTagIngredient output) {
        if (output.isEmpty()) {
            return;
        }
        this.addOutput(new UniversalItemIngredient(output));
    }
}

