/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.item.armor;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kenddie.fantasyarmor.client.model.FAArmorModel;
import net.kenddie.fantasyarmor.client.render.FAArmorRenderer;
import net.kenddie.fantasyarmor.config.FAArmorEffectsConfig;
import net.kenddie.fantasyarmor.config.FAConfig;
import net.kenddie.fantasyarmor.item.armor.FAArmorAttributes;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public abstract class FAArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final FAArmorSet armorSet;
    private final Supplier<FAArmorAttributes> attributesSupplier;
    private ItemAttributeModifiers cachedModifiers;
    public static final int DEFAULT_COLOR = 10511680;

    protected FAArmorItem(FAArmorSet armorSet, ArmorItem.Type type, Supplier<FAArmorAttributes> attributesSupplier) {
        super(ArmorMaterials.NETHERITE, type, new Item.Properties().stacksTo(1).fireResistant());
        this.armorSet = armorSet;
        this.attributesSupplier = attributesSupplier;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean hasCustomColor(ItemStack stack) {
        return stack.has(DataComponents.DYED_COLOR);
    }

    public int getColor(ItemStack stack) {
        DyedItemColor color = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        return color != null ? color.rgb() : 10511680;
    }

    public void setColor(ItemStack stack, int color) {
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, false));
    }

    public void clearColor(ItemStack stack) {
        stack.remove(DataComponents.DYED_COLOR);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        if (!FAConfig.showDescriptions) {
            return;
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        String translationKey = this.getDescriptionId() + ".tooltip";
        pTooltipComponents.add((Component)Component.translatable((String)translationKey));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<? extends FAArmorItem> renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = FAArmorItem.this.createArmorRenderer();
                }
                return this.renderer;
            }
        });
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        if (!FAConfig.applyModifiers) {
            return super.getDefaultAttributeModifiers();
        }
        if (this.cachedModifiers == null) {
            this.cachedModifiers = this.buildModifiers();
        }
        return this.cachedModifiers;
    }

    private ItemAttributeModifiers buildModifiers() {
        FAArmorAttributes armorAttributes = this.attributesSupplier.get();
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup slotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot());
        String slotName = this.type.getName();
        if (armorAttributes.armor() != 0.0) {
            builder.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"fantasy_armor", (String)(slotName + "_armor")), armorAttributes.armor(), AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        if (armorAttributes.armorToughness() != 0.0) {
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"fantasy_armor", (String)(slotName + "_armor_toughness")), armorAttributes.armorToughness(), AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        if (armorAttributes.knockbackResistance() != 0.0) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"fantasy_armor", (String)(slotName + "_knockback")), armorAttributes.knockbackResistance(), AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        if (armorAttributes.movementSpeed() != 0.0) {
            builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"fantasy_armor", (String)(slotName + "_speed")), armorAttributes.movementSpeed(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), slotGroup);
        }
        if (armorAttributes.maxHealth() != 0.0) {
            builder.add(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"fantasy_armor", (String)(slotName + "_health")), armorAttributes.maxHealth(), AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        if (armorAttributes.attackDamage() != 0.0) {
            builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"fantasy_armor", (String)(slotName + "_attack_damage")), armorAttributes.attackDamage(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), slotGroup);
        }
        if (armorAttributes.attackSpeed() != 0.0) {
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"fantasy_armor", (String)(slotName + "_attack_speed")), armorAttributes.attackSpeed(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), slotGroup);
        }
        if (armorAttributes.luck() != 0.0) {
            builder.add(Attributes.LUCK, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"fantasy_armor", (String)(slotName + "_luck")), armorAttributes.luck(), AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        return builder.build();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected GeoArmorRenderer<? extends FAArmorItem> createArmorRenderer() {
        boolean dyeable = FAArmorItem.resourceExists(ResourceLocation.fromNamespaceAndPath((String)"fantasy_armor", (String)this.armorSet.getOverlayPath()));
        return new FAArmorRenderer(new FAArmorModel(this.armorSet.getGeoPath(), this.armorSet.getTexturePath()), dyeable);
    }

    public List<MobEffectInstance> getFullSetEffects() {
        return ((FAArmorEffectsConfig)FAArmorEffectsConfig.ARMOR_EFFECTS_CONFIGS.getOrDefault(this.armorSet.getName(), null)).getEffects();
    }

    public FAArmorSet getArmorSet() {
        return this.armorSet;
    }

    public static boolean resourceExists(ResourceLocation location) {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        try {
            return resourceManager.getResource(location).isPresent();
        }
        catch (Exception e) {
            return false;
        }
    }
}

