/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.kenddie.fantasyarmor.config.FAArmorAttributesConfig;
import net.kenddie.fantasyarmor.config.FAArmorConfig;
import net.kenddie.fantasyarmor.item.FAItems;
import net.kenddie.fantasyarmor.item.armor.FAArmorAttributes;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;

public final class FAArmorItems {
    public static final ArrayList<ArmorItem.Type> VALID_ARMOR_TYPES = new ArrayList<ArmorItem.Type>(List.of(ArmorItem.Type.HELMET, ArmorItem.Type.CHESTPLATE, ArmorItem.Type.LEGGINGS, ArmorItem.Type.BOOTS));
    public static final Map<FAArmorSet, Map<ArmorItem.Type, DeferredItem<Item>>> ARMOR_ITEMS = new HashMap<FAArmorSet, Map<ArmorItem.Type, DeferredItem<Item>>>();

    public static void register(IEventBus eventBus) {
        for (FAArmorSet set : FAArmorSet.values()) {
            HashMap<ArmorItem.Type, DeferredItem> setPieces = new HashMap<ArmorItem.Type, DeferredItem>();
            for (ArmorItem.Type type : VALID_ARMOR_TYPES) {
                String name = set.getName() + "_" + type.getName();
                FAArmorAttributesConfig config = FAArmorConfig.ARMOR_CONFIGS.get(set.getName()).get(type.getName());
                Supplier<FAArmorAttributes> attributesSupplier = () -> new FAArmorAttributes.Builder().armor((Double)config.armor.get()).armorToughness((Double)config.armorToughness.get()).knockbackResistance((Double)config.knockbackResistance.get()).movementSpeed((Double)config.movementSpeed.get()).maxHealth((Double)config.maxHealth.get()).attackDamage((Double)config.attackDamage.get()).attackSpeed((Double)config.attackSpeed.get()).luck((Double)config.luck.get()).build();
                DeferredItem item = FAItems.ITEMS.register(name, () -> set.create(type, attributesSupplier));
                setPieces.put(type, item);
            }
            ARMOR_ITEMS.put(set, setPieces);
        }
    }

    public static DeferredItem<Item> getArmorItem(FAArmorSet set, ArmorItem.Type type) {
        return ARMOR_ITEMS.get((Object)set).get(type);
    }

    private FAArmorItems() {
    }
}

