/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.config;

import java.util.HashMap;
import java.util.Map;
import net.kenddie.fantasyarmor.item.armor.FAArmorAttributes;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.world.item.ArmorItem;
import net.neoforged.neoforge.common.ModConfigSpec;

public class FAArmorAttributesConfig {
    public final ModConfigSpec.DoubleValue armor;
    public final ModConfigSpec.DoubleValue armorToughness;
    public final ModConfigSpec.DoubleValue knockbackResistance;
    public final ModConfigSpec.DoubleValue movementSpeed;
    public final ModConfigSpec.DoubleValue maxHealth;
    public final ModConfigSpec.DoubleValue attackDamage;
    public final ModConfigSpec.DoubleValue attackSpeed;
    public final ModConfigSpec.DoubleValue luck;
    private static final Map<FAArmorSet, Map<ArmorItem.Type, FAArmorAttributes>> DEFAULTS = new HashMap<FAArmorSet, Map<ArmorItem.Type, FAArmorAttributes>>();

    public FAArmorAttributesConfig(ModConfigSpec.Builder builder, FAArmorSet armorSet, ArmorItem.Type type) {
        FAArmorAttributes defaults = DEFAULTS.getOrDefault((Object)armorSet, Map.of()).getOrDefault(type, this.getGlobalDefaults(type));
        this.armor = builder.defineInRange("armor", defaults.armor(), 0.0, 100.0);
        this.armorToughness = builder.defineInRange("armorToughness", defaults.armorToughness(), 0.0, 100.0);
        this.knockbackResistance = builder.defineInRange("knockbackResistance", defaults.knockbackResistance(), 0.0, 1.0);
        this.movementSpeed = builder.defineInRange("movementSpeed", defaults.movementSpeed(), -1.0, 1.0);
        this.maxHealth = builder.defineInRange("maxHealth", defaults.maxHealth(), 0.0, 100.0);
        this.attackDamage = builder.defineInRange("attackDamage", defaults.attackDamage(), 0.0, 100.0);
        this.attackSpeed = builder.defineInRange("attackSpeed", defaults.attackSpeed(), -1.0, 1.0);
        this.luck = builder.defineInRange("luck", defaults.luck(), -100.0, 100.0);
    }

    private FAArmorAttributes getGlobalDefaults(ArmorItem.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.HELMET, ArmorItem.Type.BOOTS -> new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).build();
            case ArmorItem.Type.CHESTPLATE, ArmorItem.Type.BODY -> new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.1).build();
            case ArmorItem.Type.LEGGINGS -> new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).build();
        };
    }

    static {
        HashMap<ArmorItem.Type, FAArmorAttributes> eclipseSoldier = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        eclipseSoldier.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.1).build());
        eclipseSoldier.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).build());
        eclipseSoldier.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).build());
        eclipseSoldier.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.ECLIPSE_SOLDIER, eclipseSoldier);
        HashMap<ArmorItem.Type, FAArmorAttributes> dragonslayer = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        dragonslayer.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).build());
        dragonslayer.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.1).build());
        dragonslayer.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).build());
        dragonslayer.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.DRAGONSLAYER, dragonslayer);
        HashMap<ArmorItem.Type, FAArmorAttributes> hero = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        hero.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackDamage(0.1).attackSpeed(0.1).build());
        hero.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).attackDamage(0.1).attackSpeed(0.1).build());
        hero.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).build());
        hero.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.HERO, hero);
        HashMap<ArmorItem.Type, FAArmorAttributes> goldenHorns = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        goldenHorns.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).attackSpeed(0.1).build());
        goldenHorns.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.01).attackSpeed(0.1).build());
        goldenHorns.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.02).build());
        goldenHorns.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.04).build());
        DEFAULTS.put(FAArmorSet.GOLDEN_HORNS, goldenHorns);
        HashMap<ArmorItem.Type, FAArmorAttributes> thief = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        thief.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).attackSpeed(0.1).luck(1.0).build());
        thief.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).attackSpeed(0.1).build());
        thief.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.1).attackSpeed(0.1).build());
        thief.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.1).attackSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.THIEF, thief);
        HashMap<ArmorItem.Type, FAArmorAttributes> wanderingWizard = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        wanderingWizard.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).luck(2.0).build());
        wanderingWizard.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        wanderingWizard.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        wanderingWizard.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.WANDERING_WIZARD, wanderingWizard);
        HashMap<ArmorItem.Type, FAArmorAttributes> chessBoardKnight = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        chessBoardKnight.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).build());
        chessBoardKnight.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).build());
        chessBoardKnight.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).build());
        chessBoardKnight.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).build());
        DEFAULTS.put(FAArmorSet.CHESS_BOARD_KNIGHT, chessBoardKnight);
        HashMap<ArmorItem.Type, FAArmorAttributes> darkLord = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        darkLord.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        darkLord.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.03).build());
        darkLord.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.03).build());
        darkLord.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        DEFAULTS.put(FAArmorSet.DARK_LORD, darkLord);
        HashMap<ArmorItem.Type, FAArmorAttributes> sunsetWings = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        sunsetWings.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).maxHealth(1.0).build());
        sunsetWings.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).maxHealth(1.0).build());
        sunsetWings.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).maxHealth(1.0).build());
        sunsetWings.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).maxHealth(1.0).build());
        DEFAULTS.put(FAArmorSet.SUNSET_WINGS, sunsetWings);
        HashMap<ArmorItem.Type, FAArmorAttributes> fogGuard = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        fogGuard.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.1).build());
        fogGuard.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.01).build());
        fogGuard.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.02).build());
        fogGuard.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.03).build());
        DEFAULTS.put(FAArmorSet.FOG_GUARD, fogGuard);
        HashMap<ArmorItem.Type, FAArmorAttributes> darkCover = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        darkCover.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(2.0).build());
        darkCover.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.1).build());
        darkCover.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        darkCover.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.DARK_COVER, darkCover);
        HashMap<ArmorItem.Type, FAArmorAttributes> sparkOfDawn = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        sparkOfDawn.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.1).build());
        sparkOfDawn.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.05).build());
        sparkOfDawn.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).movementSpeed(0.05).maxHealth(1.0).attackSpeed(0.05).build());
        sparkOfDawn.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.SPARK_OF_DAWN, sparkOfDawn);
        HashMap<ArmorItem.Type, FAArmorAttributes> goldenExecution = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        goldenExecution.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).attackSpeed(0.05).build());
        goldenExecution.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(4.0).attackSpeed(0.05).build());
        goldenExecution.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        goldenExecution.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        DEFAULTS.put(FAArmorSet.GOLDEN_EXECUTION, goldenExecution);
        HashMap<ArmorItem.Type, FAArmorAttributes> forgottenTrace = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        forgottenTrace.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).luck(1.0).build());
        forgottenTrace.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).maxHealth(2.0).build());
        forgottenTrace.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.02).maxHealth(1.0).build());
        forgottenTrace.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).movementSpeed(0.05).maxHealth(1.0).luck(1.0).build());
        DEFAULTS.put(FAArmorSet.FORGOTTEN_TRACE, forgottenTrace);
        HashMap<ArmorItem.Type, FAArmorAttributes> redeemer = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        redeemer.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(2.0).attackSpeed(0.05).luck(1.0).build());
        redeemer.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(2.0).attackSpeed(0.03).movementSpeed(0.02).luck(1.0).build());
        redeemer.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).movementSpeed(0.04).build());
        redeemer.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.02).build());
        DEFAULTS.put(FAArmorSet.REDEEMER, redeemer);
        HashMap<ArmorItem.Type, FAArmorAttributes> twinned = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        twinned.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.1).movementSpeed(0.02).build());
        twinned.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.02).movementSpeed(0.02).build());
        twinned.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.05).movementSpeed(0.02).build());
        twinned.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.05).movementSpeed(0.02).build());
        DEFAULTS.put(FAArmorSet.TWINNED, twinned);
        HashMap<ArmorItem.Type, FAArmorAttributes> gildedHunt = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        gildedHunt.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.1).build());
        gildedHunt.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.1).build());
        gildedHunt.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).build());
        gildedHunt.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.GILDED_HUNT, gildedHunt);
        HashMap<ArmorItem.Type, FAArmorAttributes> ladyMaria = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        ladyMaria.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.05).luck(1.0).build());
        ladyMaria.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).attackSpeed(0.05).build());
        ladyMaria.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        ladyMaria.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).build());
        DEFAULTS.put(FAArmorSet.LADY_MARIA, ladyMaria);
        HashMap<ArmorItem.Type, FAArmorAttributes> crucibleKnight = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        crucibleKnight.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).build());
        crucibleKnight.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).build());
        crucibleKnight.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).build());
        crucibleKnight.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.CRUCIBLE_KNIGHT, crucibleKnight);
        HashMap<ArmorItem.Type, FAArmorAttributes> eveningGhost = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        eveningGhost.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).luck(1.0).build());
        eveningGhost.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).luck(1.0).build());
        eveningGhost.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.04).build());
        eveningGhost.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.EVENING_GHOST, eveningGhost);
        HashMap<ArmorItem.Type, FAArmorAttributes> ronin = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        ronin.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.1).build());
        ronin.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.1).build());
        ronin.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).build());
        ronin.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.RONIN, ronin);
        HashMap<ArmorItem.Type, FAArmorAttributes> malenia = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        malenia.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.07).attackSpeed(0.05).build());
        malenia.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).movementSpeed(0.05).attackSpeed(0.05).build());
        malenia.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        malenia.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.08).build());
        DEFAULTS.put(FAArmorSet.MALENIA, malenia);
        HashMap<ArmorItem.Type, FAArmorAttributes> oldKnight = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        oldKnight.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        oldKnight.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).build());
        oldKnight.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        oldKnight.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.OLD_KNIGHT, oldKnight);
        HashMap<ArmorItem.Type, FAArmorAttributes> silverKnight = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        silverKnight.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).luck(1.0).attackSpeed(0.03).build());
        silverKnight.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).luck(1.0).attackSpeed(0.03).build());
        silverKnight.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        silverKnight.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).luck(1.0).build());
        DEFAULTS.put(FAArmorSet.SILVER_KNIGHT, silverKnight);
        HashMap<ArmorItem.Type, FAArmorAttributes> deadGladiator = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        deadGladiator.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).attackDamage(0.05).build());
        deadGladiator.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.2).attackDamage(0.1).build());
        deadGladiator.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).attackDamage(0.05).build());
        deadGladiator.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.DEAD_GLADIATOR, deadGladiator);
        HashMap<ArmorItem.Type, FAArmorAttributes> fleshOfTheFeaster = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        fleshOfTheFeaster.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(1.0).knockbackResistance(0.1).maxHealth(1.0).build());
        fleshOfTheFeaster.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(1.0).knockbackResistance(0.2).maxHealth(2.0).build());
        fleshOfTheFeaster.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(1.0).knockbackResistance(0.1).maxHealth(1.0).build());
        fleshOfTheFeaster.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(1.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.FLESH_OF_THE_FEASTER, fleshOfTheFeaster);
        HashMap<ArmorItem.Type, FAArmorAttributes> windWorshipper = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        windWorshipper.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).attackSpeed(0.03).build());
        windWorshipper.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.2).attackSpeed(0.03).build());
        windWorshipper.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        windWorshipper.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).movementSpeed(0.03).build());
        DEFAULTS.put(FAArmorSet.WIND_WORSHIPPER, windWorshipper);
        HashMap<ArmorItem.Type, FAArmorAttributes> graveSentinel = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        graveSentinel.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).attackSpeed(0.03).build());
        graveSentinel.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.2).attackSpeed(0.03).build());
        graveSentinel.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        graveSentinel.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.2).movementSpeed(0.03).build());
        DEFAULTS.put(FAArmorSet.GRAVE_SENTINEL, graveSentinel);
        HashMap<ArmorItem.Type, FAArmorAttributes> ornstein = new HashMap<ArmorItem.Type, FAArmorAttributes>();
        ornstein.put(ArmorItem.Type.HELMET, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).attackDamage(0.05).maxHealth(2.0).build());
        ornstein.put(ArmorItem.Type.CHESTPLATE, new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.2).maxHealth(2.0).attackDamage(0.05).build());
        ornstein.put(ArmorItem.Type.LEGGINGS, new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).movementSpeed(0.03).maxHealth(2.0).build());
        ornstein.put(ArmorItem.Type.BOOTS, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.2).movementSpeed(0.03).build());
        DEFAULTS.put(FAArmorSet.ORNSTEIN, ornstein);
    }
}

