/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.client.render;

import net.minecraft.client.model.PlayerModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public final class FARenderUtils {
    public static void applyCapeRotation(Player player, GeoBone bone, float partialTick) {
        double d0 = Mth.lerp((double)partialTick, (double)player.xCloakO, (double)player.xCloak) - Mth.lerp((double)partialTick, (double)player.xo, (double)player.getX());
        double d1 = Mth.lerp((double)partialTick, (double)player.yCloakO, (double)player.yCloak) - Mth.lerp((double)partialTick, (double)player.yo, (double)player.getY());
        double d2 = Mth.lerp((double)partialTick, (double)player.zCloakO, (double)player.zCloak) - Mth.lerp((double)partialTick, (double)player.zo, (double)player.getZ());
        float f = Mth.rotLerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot);
        double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
        float f1 = (float)d1 * 10.0f;
        f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
        float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
        f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
        float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f4 = Mth.lerp((float)partialTick, (float)player.oBob, (float)player.bob);
        bone.updateRotation((float)(-Math.toRadians(6.0f + f2 / 2.0f + (f1 += Mth.sin((float)(Mth.lerp((float)partialTick, (float)player.walkDistO, (float)player.walkDist) * 6.0f)) * 32.0f * f4))), (float)Math.toRadians(f3 / 2.0f), (float)Math.toRadians(f3 / 2.0f));
    }

    public static <T extends Item> void setFrontLegCapeAngle(GeoArmorRenderer<T> renderer, GeoBone bone) {
        if (renderer.getLeftLegBone(renderer.getGeoModel()) == null || renderer.getRightLegBone(renderer.getGeoModel()) == null) {
            return;
        }
        GeoBone leftLegBone = renderer.getLeftLegBone(renderer.getGeoModel());
        GeoBone rightLegBone = renderer.getRightLegBone(renderer.getGeoModel());
        if (leftLegBone == null || rightLegBone == null) {
            return;
        }
        float legRot = Math.min(leftLegBone.getRotX(), rightLegBone.getRotX());
        bone.setRotX((legRot > 0.0f ? 0.0f : legRot) * -1.2f);
    }

    public static void applyBraidRotation(Player player, GeoBone braid, float partialTick) {
        FARenderUtils.applyCapeRotation(player, braid, partialTick);
        if (player.getXRot() > 60.0f) {
            braid.setRotX(0.0f);
        } else if (player.getXRot() < -35.0f) {
            braid.setRotX(30.0f);
        }
    }

    public static <T extends LivingEntity> void setArmsVisibility(PlayerModel<T> model, boolean visible) {
        model.rightArm.visible = visible;
        model.rightSleeve.visible = visible;
        model.leftArm.visible = visible;
        model.leftSleeve.visible = visible;
    }
}

