/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.kenddie.fantasyarmor.client.render.FAArmorRenderer;
import net.kenddie.fantasyarmor.item.armor.FAArmorItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class FADyeableGeoLayer<T extends FAArmorItem>
extends GeoRenderLayer<T> {
    protected static final Map<String, ResourceLocation> ARMOR_PATH_CACHE = new Object2ObjectOpenHashMap();

    public FADyeableGeoLayer(FAArmorRenderer<T> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType baseRenderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (animatable == null) {
            return;
        }
        FAArmorRenderer armorRenderer = (FAArmorRenderer)this.renderer;
        ItemStack stack = armorRenderer.getCurrentStack();
        if (!((FAArmorItem)((Object)animatable)).hasCustomColor(stack)) {
            return;
        }
        ResourceLocation overlayTex = this.getArmorResource((FAArmorItem)((Object)animatable));
        RenderType overlayType = RenderType.armorCutoutNoCull((ResourceLocation)overlayTex);
        VertexConsumer overlayBuffer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferSource, (RenderType)overlayType, (boolean)stack.hasFoil());
        int color = 0xFF000000 | ((FAArmorItem)((Object)animatable)).getColor(stack);
        this.renderer.reRender(bakedModel, poseStack, bufferSource, animatable, overlayType, overlayBuffer, partialTick, packedLight, packedOverlay, color);
    }

    public ResourceLocation getArmorResource(FAArmorItem armorItem) {
        String texture = "fantasy_armor:" + armorItem.getArmorSet().getOverlayPath();
        return ARMOR_PATH_CACHE.computeIfAbsent(texture, ResourceLocation::parse);
    }

    protected VertexConsumer getArmorBuffer(MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable ResourceLocation texturePath, boolean enchanted) {
        if (renderType == null) {
            renderType = RenderType.armorCutoutNoCull((ResourceLocation)texturePath);
        }
        return ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)enchanted);
    }
}

