/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.functions;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.starterkit_common_forge.data.Variables;
import com.natamus.starterkit_common_forge.functions.StarterDataFunctions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class StarterCheckFunctions {
    public static boolean shouldPlayerReceiveStarterKit(Player player) {
        return StarterCheckFunctions.shouldPlayerReceiveStarterKit(player.level(), player);
    }

    public static boolean shouldPlayerReceiveStarterKit(Level level, Player player) {
        if (level.isClientSide) {
            return false;
        }
        MinecraftServer minecraftServer = level.getServer();
        if (!minecraftServer.isDedicatedServer()) {
            String levelName = WorldFunctions.getWorldFolderName((MinecraftServer)minecraftServer);
            if (Variables.trackingMap.get("singleplayer").containsKey(levelName)) {
                return Variables.trackingMap.get("singleplayer").get(levelName) == false;
            }
        } else {
            String rawUUID = player.getStringUUID();
            if (Variables.trackingMap.get("multiplayer").containsKey(rawUUID)) {
                return Variables.trackingMap.get("multiplayer").get(rawUUID) == false;
            }
        }
        return true;
    }

    public static void addPlayerToTrackingMap(Player player) {
        StarterCheckFunctions.addPlayerToTrackingMap(player.level(), player);
    }

    public static void addPlayerToTrackingMap(Level level, Player player) {
        if (level.isClientSide) {
            return;
        }
        MinecraftServer minecraftServer = level.getServer();
        if (!minecraftServer.isDedicatedServer()) {
            String levelName = WorldFunctions.getWorldFolderName((MinecraftServer)minecraftServer);
            Variables.trackingMap.get("singleplayer").put(levelName, true);
        }
        String rawUUID = player.getStringUUID();
        Variables.trackingMap.get("multiplayer").put(rawUUID, true);
        StarterDataFunctions.writeTrackingMapToJsonFile(minecraftServer);
    }
}

